/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.block.custom.ProtocolAnchorCorePortBlock;
import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.blockEntity.custom.ProtocolAnchorCoreBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtocolAnchorCorePortBlockEntity
extends BlockEntity {
    private BlockPos parentPos;
    private ItemStack filter = ItemStack.f_41583_;
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new InputHandler());
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new FilteredOutputHandler());

    protected ProtocolAnchorCorePortBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ProtocolAnchorCorePortBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModBlockEntities.PROTOCOL_ANCHOR_CORE_PORT.get(), blockPos, blockState);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ProtocolAnchorCorePortBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (entity.parentPos != null) {
            return;
        }
        for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_7918_(4, 0, 4), (BlockPos)pos.m_7918_(-4, 0, -4))) {
            BlockEntity checkEntity = world.m_7702_(p);
            if (!(checkEntity instanceof ProtocolAnchorCoreBlockEntity)) continue;
            entity.setParentPos(p);
            entity.m_6596_();
            break;
        }
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        if (filter == null) {
            this.filter = ItemStack.f_41583_;
        }
        this.filter = filter.m_41777_();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void clearFilter() {
        this.filter = ItemStack.f_41583_;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nullable
    public ProtocolAnchorCoreBlockEntity getParentBlock() {
        if (this.parentPos == null || this.f_58857_ == null) {
            return null;
        }
        BlockEntity entity = this.f_58857_.m_7702_(this.parentPos);
        if (entity instanceof ProtocolAnchorCoreBlockEntity) {
            ProtocolAnchorCoreBlockEntity parentBlock = (ProtocolAnchorCoreBlockEntity)entity;
            return parentBlock;
        }
        return null;
    }

    public NonNullList<ItemStack> getItems() {
        ProtocolAnchorCoreBlockEntity parent = this.getParentBlock();
        if (parent != null) {
            return parent.getItems();
        }
        return NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
    }

    public void setParentPos(BlockPos parentPos) {
        this.parentPos = parentPos;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.parentPos != null) {
            pTag.m_128356_("parentPos", this.parentPos.m_121878_());
        }
        if (this.filter != null && !this.filter.m_41619_()) {
            CompoundTag filterTag = new CompoundTag();
            this.filter.m_41739_(filterTag);
            pTag.m_128365_("filter", (Tag)filterTag);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("parentPos")) {
            this.parentPos = BlockPos.m_122022_((long)pTag.m_128454_("parentPos"));
        }
        if (pTag.m_128441_("filter")) {
            CompoundTag filterTag = pTag.m_128469_("filter");
            this.filter = ItemStack.m_41712_((CompoundTag)filterTag);
        } else {
            this.filter = ItemStack.f_41583_;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)ProtocolAnchorCorePortBlock.FACING);
            if (side == facing) {
                return this.inputHandler.cast();
            }
            if (side == facing.m_122424_()) {
                return this.outputHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    private class FilteredOutputHandler
    implements IItemHandler {
        private FilteredOutputHandler() {
        }

        public int getSlots() {
            ProtocolAnchorCoreBlockEntity parent = ProtocolAnchorCorePortBlockEntity.this.getParentBlock();
            return parent != null ? parent.getItemHandler().getSlots() : 0;
        }

        public ItemStack getStackInSlot(int slot) {
            ProtocolAnchorCoreBlockEntity parent = ProtocolAnchorCorePortBlockEntity.this.getParentBlock();
            if (parent == null) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = parent.getItemHandler().getStackInSlot(slot);
            if (ProtocolAnchorCorePortBlockEntity.this.filter.m_41619_() || stack.m_41619_() || stack.m_41720_() == ProtocolAnchorCorePortBlockEntity.this.filter.m_41720_()) {
                return stack;
            }
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ProtocolAnchorCoreBlockEntity parent = ProtocolAnchorCorePortBlockEntity.this.getParentBlock();
            if (parent == null) {
                return ItemStack.f_41583_;
            }
            ItemStack stackInSlot = parent.getItemHandler().getStackInSlot(slot);
            if (ProtocolAnchorCorePortBlockEntity.this.filter.m_41619_() || stackInSlot.m_41720_() == ProtocolAnchorCorePortBlockEntity.this.filter.m_41720_()) {
                return parent.getItemHandler().extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }

    private class InputHandler
    implements IItemHandler {
        private InputHandler() {
        }

        public int getSlots() {
            ProtocolAnchorCoreBlockEntity parent = ProtocolAnchorCorePortBlockEntity.this.getParentBlock();
            return parent != null ? parent.getItemHandler().getSlots() : 0;
        }

        public ItemStack getStackInSlot(int slot) {
            ProtocolAnchorCoreBlockEntity parent = ProtocolAnchorCorePortBlockEntity.this.getParentBlock();
            return parent != null ? parent.getItemHandler().getStackInSlot(slot) : ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ProtocolAnchorCoreBlockEntity parent = ProtocolAnchorCorePortBlockEntity.this.getParentBlock();
            return parent != null ? parent.getItemHandler().insertItem(slot, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }
    }
}

