/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.recipe.custom;

import com.besson.endfield.recipe.InputEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class MouldingUnitRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final InputEntry input;
    private final ItemStack output;

    public MouldingUnitRecipe(ResourceLocation id, InputEntry input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public boolean m_5818_(Container inventory, Level world) {
        if (world.m_5776_()) {
            return false;
        }
        ItemStack inputs = inventory.m_8020_(0);
        return this.input.getIngredient().test(inputs);
    }

    public InputEntry getInput() {
        return this.input;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.input.getIngredient());
        return ingredients;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<MouldingUnitRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "moulding_unit";

        public MouldingUnitRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonObject ingredients = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredients);
            int count = ingredients.has("count") ? GsonHelper.m_13927_((JsonObject)ingredients, (String)"count") : 1;
            InputEntry inputs = new InputEntry(ingredient, count);
            return new MouldingUnitRecipe(id, inputs, output);
        }

        public MouldingUnitRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int count = buf.readInt();
            InputEntry inputs = new InputEntry(ingredient, count);
            ItemStack output = buf.m_130267_();
            return new MouldingUnitRecipe(id, inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buf, MouldingUnitRecipe recipe) {
            InputEntry entry = recipe.getInput();
            entry.getIngredient().m_43923_(buf);
            buf.writeInt(entry.getCount());
            buf.m_130055_(recipe.output);
        }
    }

    public static class Type
    implements RecipeType<MouldingUnitRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "moulding_unit";
    }
}

