/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.renderer.block;

import com.besson.endfield.blockEntity.custom.ElectricPylonBlockEntity;
import com.besson.endfield.blockEntity.custom.ProtocolAnchorCoreBlockEntity;
import com.besson.endfield.blockEntity.custom.RelayTowerBlockEntity;
import com.besson.endfield.renderer.block.ElectricPylonRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ElectricPylonEntityRenderer
implements BlockEntityRenderer<ElectricPylonBlockEntity> {
    private final ElectricPylonRenderer geckoRenderer;

    public ElectricPylonEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.geckoRenderer = new ElectricPylonRenderer(context);
    }

    public boolean shouldRenderOffScreen(ElectricPylonBlockEntity pBlockEntity) {
        return true;
    }

    public void render(ElectricPylonBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        this.geckoRenderer.m_6922_(entity, tickDelta, matrices, vertexConsumers, light, overlay);
        if (entity.getConnectedNode() == null) {
            return;
        }
        BlockPos pos = entity.m_58899_().m_7918_(0, 7, 0);
        BlockPos connectedPos = null;
        if (entity.m_58904_() != null) {
            BlockEntity be = entity.m_58904_().m_7702_(entity.getConnectedNode());
            if (be instanceof RelayTowerBlockEntity) {
                connectedPos = entity.getConnectedNode().m_7918_(0, 10, 0);
            } else if (be instanceof ProtocolAnchorCoreBlockEntity) {
                connectedPos = entity.getConnectedNode().m_7918_(0, 27, 0);
            }
        }
        if (connectedPos == null) {
            return;
        }
        Vec3 start = Vec3.m_82512_((Vec3i)pos).m_82546_(Vec3.m_82528_((Vec3i)entity.m_58899_()));
        Vec3 end = Vec3.m_82512_(connectedPos).m_82546_(Vec3.m_82528_((Vec3i)entity.m_58899_()));
        VertexConsumer consumer = vertexConsumers.m_6299_(RenderType.m_110504_());
        Matrix4f matrix4f = matrices.m_85850_().m_252922_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double dx = end.f_82479_ - start.f_82479_;
        double dy = end.f_82480_ - start.f_82480_;
        double dz = end.f_82481_ - start.f_82481_;
        Vec3 dir = new Vec3(dx, dy, dz).m_82541_();
        Vec3 toCam = cameraPos.m_82546_(start).m_82541_();
        Vec3 normal = dir.m_82537_(toCam).m_82541_();
        consumer.m_252986_(matrix4f, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_6122_(241, 237, 184, 255).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        consumer.m_252986_(matrix4f, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_6122_(241, 237, 184, 255).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }
}

