/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.block.ElectrifiableDevice;
import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.recipe.custom.OreRigRecipe;
import com.besson.endfield.screen.custom.ElectricMiningRigScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ElectricMiningRigBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider,
ElectrifiableDevice {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ElectricMiningRigBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<ItemStackHandler> lazyItemHandler = LazyOptional.of(() -> this.itemStackHandler);
    private static final int OUTPUT_SLOT = 0;
    private int storePower = 0;
    private static final int POWER_PRE_TICK = 5;
    private boolean isWorking = false;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ElectricMiningRigBlockEntity.this.progress;
                case 1 -> ElectricMiningRigBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ElectricMiningRigBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ElectricMiningRigBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 40;

    public ElectricMiningRigBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ELECTRIC_MINING_RIG.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(0.0, 3.0, 0.0);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ElectricMiningRigBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (entity.isOutputSlotAvailable()) {
            boolean hasRecipe = entity.hasCorrectRecipe(world);
            if (entity.needsPower() || !hasRecipe) {
                entity.isWorking = false;
            } else if (!entity.needsPower() && !entity.isWorking) {
                entity.isWorking = true;
            }
            entity.m_6596_();
            world.m_7260_(pos, state, state, 3);
            if (hasRecipe && entity.storePower >= 5) {
                entity.increaseProgress();
                entity.storePower -= 5;
                if (entity.hasCraftFinished()) {
                    entity.craftItem(world);
                    entity.resetProgress();
                }
            } else {
                entity.resetProgress();
            }
        } else {
            entity.resetProgress();
        }
        entity.m_6596_();
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(Level world) {
        Optional<OreRigRecipe> match = this.getMatchRecipe(world);
        if (match.isPresent()) {
            ItemStack result = match.get().m_8043_(world.m_9598_());
            ItemStack outputStack = this.itemStackHandler.getStackInSlot(0);
            this.itemStackHandler.setStackInSlot(0, new ItemStack((ItemLike)result.m_41720_(), outputStack.m_41613_() + result.m_41613_()));
        }
    }

    private Optional<OreRigRecipe> getMatchRecipe(Level world) {
        SimpleContainer inv = new SimpleContainer(1);
        BlockState below = world.m_8055_(this.m_58899_().m_7495_());
        ItemStack belowStack = below.m_60734_().m_5456_().m_7968_();
        inv.m_6836_(0, belowStack);
        return world.m_7465_().m_44015_((RecipeType)OreRigRecipe.Type.INSTANCE, (Container)inv, world).map(recipe -> recipe);
    }

    private boolean hasCraftFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseProgress() {
        ++this.progress;
    }

    private boolean hasCorrectRecipe(Level world) {
        Optional<OreRigRecipe> match = this.getMatchRecipe(world);
        if (match.isPresent()) {
            ItemStack result = match.get().m_8043_(world.m_9598_());
            return this.canInsertItem(result);
        }
        return false;
    }

    private boolean canInsertItem(ItemStack item) {
        ItemStack outputStack = this.itemStackHandler.getStackInSlot(0);
        return outputStack.m_41619_() || outputStack.m_41720_() == item.m_41720_() && outputStack.m_41613_() + item.m_41613_() <= outputStack.m_41741_();
    }

    private boolean isOutputSlotAvailable() {
        ItemStack outputStack = this.itemStackHandler.getStackInSlot(0);
        return outputStack.m_41619_() || outputStack.m_41613_() < outputStack.m_41741_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> this.isWorking ? state.setAndContinue(RawAnimation.begin().thenLoop("working")) : state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemStackHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        pTag.m_128405_("progress", this.progress);
        pTag.m_128379_("isWorking", this.isWorking);
        pTag.m_128405_("storePower", this.storePower);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemStackHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("progress");
        this.isWorking = pTag.m_128471_("isWorking");
        this.storePower = pTag.m_128451_("storePower");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Override
    public void receiveElectricCharge(int amount) {
        this.storePower += amount;
        if (this.storePower > 100) {
            this.storePower = 100;
        }
    }

    @Override
    public boolean needsPower() {
        return this.storePower < 5;
    }

    @Override
    public int getRequiredPower() {
        return 5;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        items.set(0, (Object)this.itemStackHandler.getStackInSlot(0));
        return items;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"blockEntity.electric_mining_rig");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ElectricMiningRigScreenHandler(pContainerId, pPlayerInventory, this, this.propertyDelegate);
    }
}

