/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.block.ElectrifiableDevice;
import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.blockEntity.custom.ProtocolAnchorCoreBlockEntity;
import com.besson.endfield.blockEntity.custom.RelayTowerBlockEntity;
import com.besson.endfield.power.PowerNetworkManager;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ElectricPylonBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private BlockPos connectedNode;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean registeredToManager = false;

    public ElectricPylonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ELECTRIC_PYLON.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(0.0, 8.0, 0.0);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ElectricPylonBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (entity.connectedNode == null || world.m_7702_(entity.connectedNode) == null) {
            BlockPos closest = null;
            double closestDist = Double.MAX_VALUE;
            for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_7918_(-30, -30, -30), (BlockPos)pos.m_7918_(30, 30, 30))) {
                double d;
                BlockEntity candidate;
                if (p.equals((Object)pos) || !((candidate = world.m_7702_(p)) instanceof ProtocolAnchorCoreBlockEntity) && !(candidate instanceof RelayTowerBlockEntity) || !((d = pos.m_123331_((Vec3i)p)) < closestDist)) continue;
                closest = p.m_7949_();
                closestDist = d;
            }
            entity.connectedNode = closest;
            ElectricPylonBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            world.m_7260_(pos, state, state, 3);
        }
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        if (!this.registeredToManager && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            PowerNetworkManager.get(serverLevel).registerConsumer(this.m_58899_(), () -> {
                try {
                    return this.getSurroundingDemand();
                }
                catch (Throwable t) {
                    return 0;
                }
            }, amount -> {
                try {
                    this.distributeToSurroundings((Integer)amount);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.registeredToManager = true;
        }
    }

    private void distributeToSurroundings(Integer amount) {
        if (this.f_58857_ == null || amount <= 0) {
            return;
        }
        ArrayList<ElectrifiableDevice> devices = new ArrayList<ElectrifiableDevice>();
        for (BlockPos target : BlockPos.m_121940_((BlockPos)this.m_58899_().m_7918_(-10, -10, -10), (BlockPos)this.m_58899_().m_7918_(10, 10, 10))) {
            ElectrifiableDevice device;
            BlockEntity be = this.f_58857_.m_7702_(target);
            if (!(be instanceof ElectrifiableDevice) || !(device = (ElectrifiableDevice)be).needsPower()) continue;
            devices.add(device);
        }
        if (devices.isEmpty()) {
            return;
        }
        int perDevice = amount / devices.size();
        for (ElectrifiableDevice device : devices) {
            int required = device.getRequiredPower();
            int toGive = Math.min(perDevice, required);
            device.receiveElectricCharge(toGive);
            if ((amount = Integer.valueOf(amount - toGive)) > 0) continue;
            break;
        }
    }

    private Integer getSurroundingDemand() {
        if (this.f_58857_ == null) {
            return 0;
        }
        int totalDemand = 0;
        for (BlockPos target : BlockPos.m_121940_((BlockPos)this.m_58899_().m_7918_(-10, -10, -10), (BlockPos)this.m_58899_().m_7918_(10, 10, 10))) {
            ElectrifiableDevice device;
            BlockEntity be = this.f_58857_.m_7702_(target);
            if (!(be instanceof ElectrifiableDevice) || !(device = (ElectrifiableDevice)be).needsPower()) continue;
            totalDemand += device.getRequiredPower();
        }
        return totalDemand;
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PowerNetworkManager.get(serverLevel).unregisterConsumer(this.m_58899_());
        }
        super.m_7651_();
    }

    public BlockPos getConnectedNode() {
        return this.connectedNode;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.connectedNode != null) {
            pTag.m_128356_("connectedNode", this.connectedNode.m_121878_());
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("connectedNode")) {
            this.connectedNode = BlockPos.m_122022_((long)pTag.m_128454_("connectedNode"));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("working")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

