/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.blockEntity.custom.ProtocolAnchorCoreBlockEntity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RelayTowerBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private BlockPos connectedNode;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RelayTowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RELAY_TOWER.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, RelayTowerBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (entity.connectedNode == null || world.m_7702_(entity.connectedNode) == null) {
            BlockPos closest = null;
            double closestDist = Double.MAX_VALUE;
            for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_7918_(-30, -30, -30), (BlockPos)pos.m_7918_(30, 30, 30))) {
                double d;
                BlockEntity candidate;
                if (p.equals((Object)pos) || !((candidate = world.m_7702_(p)) instanceof ProtocolAnchorCoreBlockEntity) && !(candidate instanceof RelayTowerBlockEntity) || !((d = pos.m_123331_((Vec3i)p)) < closestDist)) continue;
                closest = p.m_7949_();
                closestDist = d;
            }
            entity.connectedNode = closest;
            RelayTowerBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            world.m_7260_(pos, state, state, 3);
        }
    }

    public BlockPos getConnectedNode() {
        return this.connectedNode;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(0.0, 11.0, 0.0);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.connectedNode != null) {
            pTag.m_128356_("connectedNode", this.connectedNode.m_121878_());
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("connectedNode")) {
            this.connectedNode = BlockPos.m_122022_((long)pTag.m_128454_("connectedNode"));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public ProtocolAnchorCoreBlockEntity getConnectedCore(Level world) {
        return this.findConnectedCore(world, new HashSet<BlockPos>());
    }

    private ProtocolAnchorCoreBlockEntity findConnectedCore(Level world, Set<BlockPos> visited) {
        if (this.connectedNode == null) {
            return null;
        }
        if (visited.contains(this.m_58899_())) {
            return null;
        }
        visited.add(this.m_58899_());
        BlockEntity be = world.m_7702_(this.connectedNode);
        if (be instanceof ProtocolAnchorCoreBlockEntity) {
            ProtocolAnchorCoreBlockEntity core = (ProtocolAnchorCoreBlockEntity)be;
            return core;
        }
        if (be instanceof RelayTowerBlockEntity) {
            RelayTowerBlockEntity relay = (RelayTowerBlockEntity)be;
            return relay.findConnectedCore(world, visited);
        }
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

