/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockEntity.custom;

import com.besson.endfield.blockEntity.ModBlockEntities;
import com.besson.endfield.power.PowerNetworkManager;
import com.besson.endfield.screen.custom.ThermalBankScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ThermalBankBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ThermalBankBlockEntity.this.m_6596_();
        }
    };
    private int burnTime;
    private int fuelTime;
    protected final ContainerData propertyDelegate;
    private boolean registeredToManager = false;
    public static final int INPUT_SLOT = 0;
    private final LazyOptional<ItemStackHandler> lazyOptional = LazyOptional.of(() -> this.itemStackHandler);

    public ThermalBankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.THERMAL_BANK.get(), pos, state);
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> ThermalBankBlockEntity.this.burnTime;
                    case 1 -> ThermalBankBlockEntity.this.fuelTime;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        ThermalBankBlockEntity.this.burnTime = value;
                        break;
                    }
                    case 1: {
                        ThermalBankBlockEntity.this.fuelTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList list = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        list.set(0, (Object)this.itemStackHandler.getStackInSlot(0));
        return list;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ThermalBankBlockEntity entity) {
        ItemStack stack;
        Integer fuelValue;
        if (entity.burnTime > 0) {
            --entity.burnTime;
        }
        if (entity.burnTime == 0 && (fuelValue = Integer.valueOf(ForgeHooks.getBurnTime((ItemStack)(stack = entity.itemStackHandler.getStackInSlot(0)), (RecipeType)RecipeType.f_44108_))) != null && fuelValue > 0) {
            int fuelTime;
            entity.fuelTime = fuelTime = fuelValue / 2;
            entity.burnTime = fuelTime;
            stack.m_41774_(1);
            entity.itemStackHandler.setStackInSlot(0, stack);
            entity.m_6596_();
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getPowerOutput() {
        return this.isBurning() ? 150 : 0;
    }

    public float getFuelProgress() {
        if (this.fuelTime == 0) {
            return 0.0f;
        }
        return (float)this.burnTime / (float)this.fuelTime;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.itemStackHandler.serializeNBT();
        pTag.m_128405_("thermal_bank.burnTime", this.burnTime);
        pTag.m_128405_("thermal_bank.fuelTime", this.fuelTime);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemStackHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.burnTime = pTag.m_128451_("thermal_bank.burnTime");
        this.fuelTime = pTag.m_128451_("thermal_bank.fuelTime");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"blockEntity.thermal_bank");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ThermalBankScreenHandler(pContainerId, pPlayerInventory, this, this.propertyDelegate);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(0.0, 4.0, 0.0);
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        if (!this.registeredToManager && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            PowerNetworkManager.get(serverLevel).registerGenerator(this.m_58899_(), () -> {
                try {
                    return this.getPowerOutput();
                }
                catch (Exception e) {
                    return 0;
                }
            });
            this.registeredToManager = true;
        }
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PowerNetworkManager.get(serverLevel).unregisterGenerator(this.m_58899_());
        }
        super.m_7651_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyOptional.invalidate();
    }

    public ContainerData getPropertyDelegate() {
        return this.propertyDelegate;
    }
}

