/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.power;

import com.besson.endfield.power.PowerState;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="arknights_endfield")
public class PowerNetworkManager {
    private static final Map<ServerLevel, PowerNetworkManager> INSTANCE = new WeakHashMap<ServerLevel, PowerNetworkManager>();
    private final ServerLevel world;
    private PowerState state;
    private final Map<BlockPos, GeneratorInfo> generators = new HashMap<BlockPos, GeneratorInfo>();
    private final Map<BlockPos, ConsumerInfo> consumers = new HashMap<BlockPos, ConsumerInfo>();
    private int lastTotalGenerated = 0;
    private int lastTotalDemand = 0;
    private double lastSupplyRatio = 0.0;
    private final int maxBatteryCapacity = 100000;
    private int currentStoredEnergy;

    public PowerNetworkManager(ServerLevel world) {
        this.world = world;
        this.state = (PowerState)world.m_8895_().m_164861_(PowerState::fromNbt, PowerState::new, "power_state");
        this.currentStoredEnergy = this.state.storedEnergy;
    }

    public static PowerNetworkManager get(ServerLevel world) {
        return INSTANCE.computeIfAbsent(world, w -> {
            PowerNetworkManager manager = new PowerNetworkManager((ServerLevel)w);
            return manager;
        });
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.START && (server = event.getServer()) != null) {
            for (ServerLevel level : server.m_129785_()) {
                PowerNetworkManager manager = PowerNetworkManager.get(level);
                manager.tick();
            }
        }
    }

    public void registerGenerator(BlockPos pos, Supplier<Integer> generatedSupplier) {
        this.generators.put(pos.m_7949_(), new GeneratorInfo(pos.m_7949_(), generatedSupplier));
    }

    public void unregisterGenerator(BlockPos pos) {
        this.generators.remove(pos.m_7949_());
    }

    public void registerConsumer(BlockPos pos, Supplier<Integer> demandSupplier, Consumer<Integer> receiveCallback) {
        this.consumers.put(pos.m_7949_(), new ConsumerInfo(pos.m_7949_(), demandSupplier, receiveCallback));
    }

    public void unregisterConsumer(BlockPos pos) {
        this.consumers.remove(pos.m_7949_());
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        void var3_9;
        double supplyRatio;
        int totalGenerated = 0;
        for (GeneratorInfo generatorInfo : this.generators.values()) {
            try {
                int v = Math.max(0, generatorInfo.generatedSupplier.get());
                totalGenerated += v;
            }
            catch (Throwable v) {}
        }
        int totalDemand = 0;
        for (ConsumerInfo c : this.consumers.values()) {
            try {
                int d = Math.max(0, c.demandSupplier.get());
                totalDemand += d;
            }
            catch (Throwable d) {}
        }
        this.lastTotalGenerated = totalGenerated;
        this.lastTotalDemand = totalDemand;
        int n = totalGenerated;
        if (totalGenerated >= totalDemand) {
            int surplus = totalGenerated - totalDemand;
            int charge = Math.min(surplus, 100000 - this.currentStoredEnergy);
            this.currentStoredEnergy += charge;
            int n2 = n - charge;
        } else {
            int deficit = totalDemand - totalGenerated;
            int discharge = Math.min(deficit, this.currentStoredEnergy);
            this.currentStoredEnergy -= discharge;
            int n3 = n + discharge;
        }
        this.lastSupplyRatio = supplyRatio = Math.min(1.0, (double)var3_9 / (double)totalDemand);
        for (ConsumerInfo c : this.consumers.values()) {
            try {
                int demand = Math.max(0, c.demandSupplier.get());
                int supply = (int)Math.floor((double)demand * supplyRatio);
                c.receivePower.accept(supply);
            }
            catch (Throwable throwable) {}
        }
        this.state.storedEnergy = this.currentStoredEnergy;
        this.state.m_77762_();
    }

    public int getLastTotalGenerated() {
        return this.lastTotalGenerated;
    }

    public int getLastTotalDemand() {
        return this.lastTotalDemand;
    }

    public double getLastSupplyRatio() {
        return this.lastSupplyRatio;
    }

    public int getCurrentStoredEnergy() {
        return this.currentStoredEnergy;
    }

    public int getMaxBatteryCapacity() {
        return 100000;
    }

    public static class GeneratorInfo {
        public final BlockPos pos;
        public final Supplier<Integer> generatedSupplier;

        public GeneratorInfo(BlockPos pos, Supplier<Integer> generatedSupplier) {
            this.pos = pos;
            this.generatedSupplier = generatedSupplier;
        }
    }

    public static class ConsumerInfo {
        public final BlockPos pos;
        public final Supplier<Integer> demandSupplier;
        public final Consumer<Integer> receivePower;

        public ConsumerInfo(BlockPos pos, Supplier<Integer> demandSupplier, Consumer<Integer> receivePower) {
            this.pos = pos;
            this.demandSupplier = demandSupplier;
            this.receivePower = receivePower;
        }
    }
}

