/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.recipe.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrafterRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Map<ItemLike, Integer> required;
    private final ItemStack output;

    public CrafterRecipe(ResourceLocation id, Map<ItemLike, Integer> required, ItemStack output) {
        this.id = id;
        this.required = required;
        this.output = output;
    }

    public boolean m_5818_(Container inventory, Level world) {
        for (Map.Entry<ItemLike, Integer> entry : this.required.entrySet()) {
            int count = 0;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (!stack.m_41720_().equals(entry.getKey().m_5456_())) continue;
                count += stack.m_41613_();
            }
            if (count >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        block0: for (Map.Entry<ItemLike, Integer> entry : this.required.entrySet()) {
            int need = entry.getValue();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (!stack.m_41720_().equals(entry.getKey().m_5456_())) continue;
                int removed = Math.min(stack.m_41613_(), need);
                stack.m_41774_(removed);
                if ((need -= removed) <= 0) continue block0;
            }
        }
        return this.output.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public Map<ItemLike, Integer> getRequired() {
        return this.required;
    }

    public static class Serializer
    implements RecipeSerializer<CrafterRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "crafter";

        public CrafterRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonObject input = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            HashMap<ItemLike, Integer> required = new HashMap<ItemLike, Integer>();
            for (Map.Entry entry : input.entrySet()) {
                ItemLike item = (ItemLike)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)((String)entry.getKey())));
                int count = ((JsonElement)entry.getValue()).getAsInt();
                required.put(item, count);
            }
            JsonObject output = GsonHelper.m_13930_((JsonObject)json, (String)"output");
            ItemLike result = (ItemLike)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)output, (String)"item")));
            int count = GsonHelper.m_13824_((JsonObject)output, (String)"count", (int)1);
            return new CrafterRecipe(id, required, new ItemStack((ItemLike)result.m_5456_(), count));
        }

        public CrafterRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int size = buf.readInt();
            HashMap<ItemLike, Integer> required = new HashMap<ItemLike, Integer>();
            for (int i = 0; i < size; ++i) {
                Item item = buf.m_130267_().m_41720_();
                int count = buf.readInt();
                required.put((ItemLike)item, count);
            }
            ItemStack output = buf.m_130267_();
            return new CrafterRecipe(id, required, output);
        }

        public void toNetwork(FriendlyByteBuf buf, CrafterRecipe recipe) {
            buf.writeInt(recipe.getRequired().size());
            for (Map.Entry<ItemLike, Integer> entry : recipe.getRequired().entrySet()) {
                buf.m_130055_(new ItemStack((ItemLike)entry.getKey().m_5456_()));
                buf.writeInt(entry.getValue().intValue());
            }
            buf.m_130055_(recipe.output);
        }
    }

    public static class Type
    implements RecipeType<CrafterRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crafter";
    }
}

