/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.recipe.custom;

import com.besson.endfield.recipe.InputEntry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class FillingUnitRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<InputEntry> input;
    private final ItemStack output;

    public FillingUnitRecipe(ResourceLocation id, NonNullList<InputEntry> input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public boolean m_5818_(Container inventory, Level world) {
        if (world.m_5776_()) {
            return false;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            inputs.add(inventory.m_8020_(i));
        }
        for (InputEntry inputEntry : this.input) {
            boolean matched = false;
            for (ItemStack stack : inputs) {
                if (!inputEntry.getIngredient().test(stack)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public NonNullList<InputEntry> getInput() {
        return this.input;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (InputEntry entry : this.input) {
            ingredients.add((Object)entry.getIngredient());
        }
        return ingredients;
    }

    public static class Serializer
    implements RecipeSerializer<FillingUnitRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "filling_unit";

        public FillingUnitRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"input");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)InputEntry.EMPTY);
            for (int i = 0; i < inputs.size(); ++i) {
                JsonObject obj = ingredients.get(i).getAsJsonObject();
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)obj);
                int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
                inputs.set(i, (Object)new InputEntry(ingredient, count));
            }
            return new FillingUnitRecipe(id, (NonNullList<InputEntry>)inputs, output);
        }

        public FillingUnitRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)InputEntry.EMPTY);
            for (int i = 0; i < inputs.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
                int count = buf.readInt();
                inputs.set(i, (Object)new InputEntry(ingredient, count));
            }
            ItemStack output = buf.m_130267_();
            return new FillingUnitRecipe(id, (NonNullList<InputEntry>)inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buf, FillingUnitRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (InputEntry entry : recipe.input) {
                entry.getIngredient().m_43923_(buf);
                buf.writeInt(entry.getCount());
            }
            buf.m_130055_(recipe.output);
        }
    }

    public static class Type
    implements RecipeType<FillingUnitRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "filling_unit";
    }
}

