/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.blockentity.custom;

import com.besson.endfield.blockentity.ModBlockEntities;
import com.besson.endfield.blockentity.custom.ThermalBankBlockEntity;
import com.besson.endfield.power.PowerNetworkManager;
import com.besson.endfield.screen.custom.ProtocolAnchorCoreScreenHandler;
import com.besson.endfield.utils.ProtocolAnchorCoreStatus;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ProtocolAnchorCoreBlockEntity
extends class_2586
implements GeoBlockEntity,
ExtendedScreenHandlerFactory {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int buffer = 0;
    private final int baseMaxBuffer = 100000;
    private final int basePower = 150;
    private int extraPower = 0;
    private boolean registeredToManager = false;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> ProtocolAnchorCoreBlockEntity.this.buffer;
                case 1 -> ProtocolAnchorCoreBlockEntity.this.getMaxBuffer();
                case 2 -> ProtocolAnchorCoreBlockEntity.this.basePower;
                case 3 -> ProtocolAnchorCoreBlockEntity.this.getExtraPower();
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 4;
        }
    };

    public ProtocolAnchorCoreBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.PROTOCOL_ANCHOR_CORE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ProtocolAnchorCoreBlockEntity entity) {
        if (world.method_8608()) {
            return;
        }
        entity.buffer = Math.min(entity.buffer + entity.getTotalPower(), entity.getMaxBuffer());
        entity.method_5431();
    }

    private int getNearbyThermalBankPower() {
        int sum = 0;
        class_2338 blockPos = this.method_11016();
        if (this.field_11863 != null) {
            for (class_2338 pos : class_2338.method_10097((class_2338)blockPos.method_10069(-30, -30, -30), (class_2338)blockPos.method_10069(30, 30, 30))) {
                class_2586 be = this.field_11863.method_8321(pos);
                if (!(be instanceof ThermalBankBlockEntity)) continue;
                ThermalBankBlockEntity blockEntity = (ThermalBankBlockEntity)be;
                sum += blockEntity.getPowerOutput();
            }
        }
        return sum;
    }

    public int getMaxBuffer() {
        return 100000 + this.getNearbyThermalBankPower();
    }

    private int getExtraPower() {
        this.extraPower = this.getNearbyThermalBankPower();
        return this.extraPower;
    }

    public int getTotalPower() {
        return 150 + this.getExtraPower();
    }

    public ProtocolAnchorCoreStatus getStatus() {
        return new ProtocolAnchorCoreStatus(this.buffer, this.getMaxBuffer(), 150, this.getExtraPower());
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        if (!this.registeredToManager && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            PowerNetworkManager manager = PowerNetworkManager.get(serverWorld);
            manager.registerGenerator(this.method_11016(), () -> {
                try {
                    return this.getTotalPower();
                }
                catch (Throwable t) {
                    return 0;
                }
            });
            this.registeredToManager = true;
        }
    }

    public void method_11012() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PowerNetworkManager.get(serverWorld).unregisterGenerator(this.method_11016());
        }
        super.method_11012();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
        PowerNetworkManager manager = PowerNetworkManager.get((class_3218)serverPlayerEntity.method_37908());
        packetByteBuf.writeDouble(manager.getLastSupplyRatio());
        packetByteBuf.writeInt(manager.getLastTotalGenerated());
        packetByteBuf.writeInt(manager.getLastTotalDemand());
        packetByteBuf.writeInt(manager.getCurrentStoredEnergy());
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"blockEntity.protocol_anchor_core");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ProtocolAnchorCoreScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.buffer = nbt.method_10550("buffer");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("buffer", this.buffer);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int getStoredPower() {
        return this.buffer;
    }

    public boolean canSupplyPower() {
        return this.buffer >= 100;
    }

    public void consumePower(int i) {
        this.buffer = Math.max(0, this.buffer - i);
        this.method_5431();
    }
}

