/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.power;

import com.besson.endfield.power.PowerState;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_26;
import net.minecraft.class_3218;

public class PowerNetworkManager {
    private static final Map<class_3218, PowerNetworkManager> INSTANCE = new WeakHashMap<class_3218, PowerNetworkManager>();
    private final class_3218 world;
    private PowerState state;
    private final Map<class_2338, GeneratorInfo> generators = new HashMap<class_2338, GeneratorInfo>();
    private final Map<class_2338, ConsumerInfo> consumers = new HashMap<class_2338, ConsumerInfo>();
    private int lastTotalGenerated = 0;
    private int lastTotalDemand = 0;
    private double lastSupplyRatio = 0.0;
    private final int maxBatteryCapacity = 100000;
    private int currentStoredEnergy;

    public PowerNetworkManager(class_3218 world) {
        this.world = world;
        class_26 manager = world.method_17983();
        this.state = (PowerState)manager.method_17924(PowerState::fromNbt, PowerState::new, "power_network_state");
        this.currentStoredEnergy = this.state.storedEnergy;
    }

    public static PowerNetworkManager get(class_3218 world) {
        return INSTANCE.computeIfAbsent(world, w -> {
            PowerNetworkManager manager = new PowerNetworkManager((class_3218)w);
            return manager;
        });
    }

    public static void registerGlobalTick() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            for (class_3218 world : server.method_3738()) {
                PowerNetworkManager manager = PowerNetworkManager.get(world);
                manager.tick();
            }
        });
    }

    public void registerGenerator(class_2338 pos, Supplier<Integer> generatedSupplier) {
        this.generators.put(pos.method_10062(), new GeneratorInfo(pos.method_10062(), generatedSupplier));
    }

    public void unregisterGenerator(class_2338 pos) {
        this.generators.remove(pos.method_10062());
    }

    public void registerConsumer(class_2338 pos, Supplier<Integer> demandSupplier, Consumer<Integer> receiveCallback) {
        this.consumers.put(pos.method_10062(), new ConsumerInfo(pos.method_10062(), demandSupplier, receiveCallback));
    }

    public void unregisterConsumer(class_2338 pos) {
        this.consumers.remove(pos.method_10062());
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        void var3_9;
        double supplyRatio;
        int totalGenerated = 0;
        for (GeneratorInfo generatorInfo : this.generators.values()) {
            try {
                int v = Math.max(0, generatorInfo.generatedSupplier.get());
                totalGenerated += v;
            }
            catch (Throwable v) {}
        }
        int totalDemand = 0;
        for (ConsumerInfo c : this.consumers.values()) {
            try {
                int d = Math.max(0, c.demandSupplier.get());
                totalDemand += d;
            }
            catch (Throwable d) {}
        }
        this.lastTotalGenerated = totalGenerated;
        this.lastTotalDemand = totalDemand;
        int n = totalGenerated;
        if (totalGenerated >= totalDemand) {
            int surplus = totalGenerated - totalDemand;
            int charge = Math.min(surplus, 100000 - this.currentStoredEnergy);
            this.currentStoredEnergy += charge;
            int n2 = n - charge;
        } else {
            int deficit = totalDemand - totalGenerated;
            int discharge = Math.min(deficit, this.currentStoredEnergy);
            this.currentStoredEnergy -= discharge;
            int n3 = n + discharge;
        }
        this.lastSupplyRatio = supplyRatio = Math.min(1.0, (double)var3_9 / (double)totalDemand);
        for (ConsumerInfo c : this.consumers.values()) {
            try {
                int demand = Math.max(0, c.demandSupplier.get());
                int supply = (int)Math.floor((double)demand * supplyRatio);
                c.receivePower.accept(supply);
            }
            catch (Throwable throwable) {}
        }
        this.state.storedEnergy = this.currentStoredEnergy;
        this.state.method_80();
    }

    public int getLastTotalGenerated() {
        return this.lastTotalGenerated;
    }

    public int getLastTotalDemand() {
        return this.lastTotalDemand;
    }

    public double getLastSupplyRatio() {
        return this.lastSupplyRatio;
    }

    public int getCurrentStoredEnergy() {
        return this.currentStoredEnergy;
    }

    public int getMaxBatteryCapacity() {
        return 100000;
    }

    public static class GeneratorInfo {
        public final class_2338 pos;
        public final Supplier<Integer> generatedSupplier;

        public GeneratorInfo(class_2338 pos, Supplier<Integer> generatedSupplier) {
            this.pos = pos;
            this.generatedSupplier = generatedSupplier;
        }
    }

    public static class ConsumerInfo {
        public final class_2338 pos;
        public final Supplier<Integer> demandSupplier;
        public final Consumer<Integer> receivePower;

        public ConsumerInfo(class_2338 pos, Supplier<Integer> demandSupplier, Consumer<Integer> receivePower) {
            this.pos = pos;
            this.demandSupplier = demandSupplier;
            this.receivePower = receivePower;
        }
    }
}

