/*
 * Decompiled with CFR 0.152.
 */
package com.besson.endfield.screen.custom;

import com.besson.endfield.blockEntity.custom.CrafterBlockEntity;
import com.besson.endfield.recipe.custom.CrafterRecipe;
import com.besson.endfield.screen.ModScreens;
import com.besson.endfield.util.CrafterResultSlot;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CrafterScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final Container outputInventory;
    private final CrafterBlockEntity entity;
    private final Player player;
    private List<CrafterRecipe> currentRecipes = List.of();
    private int selectedRecipeIndex = 0;

    public CrafterScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, (CrafterBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(packetByteBuf.m_130135_()));
    }

    public CrafterScreenHandler(int syncId, Inventory playerInventory, CrafterBlockEntity blockEntity) {
        super((MenuType)ModScreens.CRAFTER_SCREEN.get(), syncId);
        CrafterScreenHandler.m_38869_((Container)blockEntity.getContainer(), (int)4);
        this.inventory = blockEntity.asContainer();
        this.inventory.m_5856_(playerInventory.f_35978_);
        this.entity = blockEntity;
        this.player = playerInventory.f_35978_;
        this.outputInventory = new SimpleContainer(1);
        this.m_38897_(new Slot(this.inventory, 0, 30, 35){

            public void m_6654_() {
                super.m_6654_();
                CrafterScreenHandler.this.m_6199_(CrafterScreenHandler.this.inventory);
            }
        });
        this.m_38897_(new Slot(this.inventory, 1, 48, 35){

            public void m_6654_() {
                super.m_6654_();
                CrafterScreenHandler.this.m_6199_(CrafterScreenHandler.this.inventory);
            }
        });
        this.m_38897_(new Slot(this.inventory, 2, 66, 35){

            public void m_6654_() {
                super.m_6654_();
                CrafterScreenHandler.this.m_6199_(CrafterScreenHandler.this.inventory);
            }
        });
        this.m_38897_(new CrafterResultSlot(this.player, this.inventory, this.outputInventory, 0, 124, 35, this));
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (invSlot == 3) {
                ItemStack crafted;
                while (slot.m_6657_() && this.m_5882_(originalStack, (Slot)this.f_38839_.get(3)) && this.m_38903_(crafted = slot.m_7993_(), 4, 40, true)) {
                    slot.m_142406_(player, originalStack);
                }
            } else if (invSlot >= 4 && invSlot < 40 ? !this.m_38903_(originalStack, 0, 3, false) : !this.m_38903_(originalStack, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public void m_6199_(Container pContainer) {
        super.m_6199_(pContainer);
        if (pContainer == this.inventory) {
            this.updateResult();
        }
    }

    public void updateResult() {
        Level world = this.player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        this.currentRecipes = world.m_7465_().m_44056_((RecipeType)CrafterRecipe.Type.INSTANCE, this.inventory, world);
        if (!this.currentRecipes.isEmpty()) {
            if (this.selectedRecipeIndex >= this.currentRecipes.size()) {
                this.selectedRecipeIndex = 0;
            }
            ItemStack result = this.currentRecipes.get(this.selectedRecipeIndex).m_8043_(world.m_9598_());
            this.outputInventory.m_6836_(0, result.m_41777_());
        } else {
            this.outputInventory.m_6836_(0, ItemStack.f_41583_);
        }
        this.outputInventory.m_6596_();
    }

    public void changeRecipe() {
        if (!this.currentRecipes.isEmpty()) {
            this.selectedRecipeIndex = (this.selectedRecipeIndex + 1) % this.currentRecipes.size();
            this.updateResult();
        }
    }

    public boolean m_6875_(Player pPlayer) {
        return this.inventory.m_6542_(pPlayer);
    }

    public List<CrafterRecipe> getCurrentRecipes() {
        return this.currentRecipes;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        if (!pPlayer.m_9236_().m_5776_()) {
            this.m_150411_(pPlayer, this.inventory);
        }
    }
}

