#define DITHER_PIXEL_SIZE 2

#ifndef PI
#define PI 3.1415926
#endif

float easeInOutCubic(float x) {
    // https://www.shadertoy.com/view/sd3fzB
    return x < 0.5 ? 
        4. * x * x * x : 
        1. - pow(-2. * x + 2., 3.) / 2.;
}

const mat4 DITHER_MAT = mat4(
    // https://discourse.urho3d.io/t/screen-door-transparency/5054/2
    1.0 / 17.0,  9.0 / 17.0,  3.0 / 17.0,  11.0 / 17.0,
    13.0 / 17.0, 5.0 / 17.0,  15.0 / 17.0, 7.0 / 17.0,
    4.0 / 17.0,  12.0 / 17.0, 2.0 / 17.0,  10.0 / 17.0,
    16.0 / 17.0, 8.0 / 17.0,  14.0 / 17.0, 6.0 / 17.0
);

void eg_applyDitherMatrix(float dist, vec2 fragCoord) {
    int x = int(fragCoord.x);
    int y = int(fragCoord.y);
    if (dist < DITHER_MAT[x % 4][y % 4]) discard;
}

void eg_applyChunkFadeDither(ivec3 chunkPosition, ivec3 cameraBlockPos, float visiblity, vec2 screenCoord) {
    vec3 centeredChunkPos = (floor(chunkPosition + 8) * 16 / 16) - cameraBlockPos;
    float chunkDist = length(centeredChunkPos) / 16.0;
    if(chunkDist > 2) {
        eg_applyDitherMatrix(easeInOutCubic(visiblity), screenCoord.xy / float(DITHER_PIXEL_SIZE));
    }
}