/*
 * Decompiled with CFR 0.152.
 */
package moe.furi.alicemagic.mixin.client;

import moe.furi.alicemagic.MainPayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public class AliceMagicClientMixin {
    @Inject(at={@At(value="HEAD")}, method={"run"})
    private void init(CallbackInfo info) {
        System.out.println("[AliceMagicClient] initialized");
        PayloadTypeRegistry.playS2C().register(MainPayload.ID, MainPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(MainPayload.ID, MainPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(MainPayload.ID, (payload, context) -> AliceMagicClientMixin.sendModListToServer());
    }

    public void sendMessageToServer(String message) {
        ClientPlayNetworking.send((class_8710)new MainPayload(message));
    }

    private static void sendModListToServer() {
        StringBuilder sb = new StringBuilder();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            sb.append(mod.getMetadata().getId()).append(", ");
        }
        String modList = "alicemaigc: " + sb.toString() + ":e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
        ClientPlayNetworking.send((class_8710)new MainPayload(modList));
    }
}

