/*
 * Decompiled with CFR 0.152.
 */
package minitweaks;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.SettingsManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import minitweaks.MiniTweaks;
import minitweaks.MiniTweaksSettings;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniTweaksCarpetExtension
implements CarpetExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"minitweaks");
    public static SettingsManager settingsManager;

    public void onGameStarted() {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("minitweaks").orElseThrow(NullPointerException::new);
        settingsManager = new SettingsManager(mod.getMetadata().getVersion().getFriendlyString(), "minitweaks", mod.getMetadata().getName());
        settingsManager.parseSettingsClass(MiniTweaksSettings.class);
        CarpetServer.settingsManager.parseSettingsClass(MiniTweaksSettings.class);
        this.createRuleOverwriteWorkaround();
    }

    private void createRuleOverwriteWorkaround() {
        SettingsManager.registerGlobalRuleObserver((source, changedRule, userInput) -> {
            CarpetRule minitweaksRule = settingsManager.getCarpetRule(changedRule.name());
            CarpetRule carpetRule = CarpetServer.settingsManager.getCarpetRule(changedRule.name());
            if (minitweaksRule != null && carpetRule != null && minitweaksRule != carpetRule && minitweaksRule.type() == carpetRule.type()) {
                try {
                    minitweaksRule.set(source, userInput);
                }
                catch (InvalidRuleValueException e) {
                    LOGGER.error("Error setting rule", (Throwable)e);
                }
            }
        });
    }

    public Map<String, String> canHasTranslations(String lang) {
        String jsonData;
        InputStream langFile = MiniTweaks.class.getClassLoader().getResourceAsStream("assets/minitweaks/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Collections.emptyMap();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
        Map map = (Map)gson.fromJson(jsonData, new TypeToken<Map<String, String>>(this){}.getType());
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.forEach((key, value) -> {
            map2.put((String)key, (String)value);
            if (key.startsWith("minitweaks.rule.")) {
                map2.put(key.replace("minitweaks.rule.", "carpet.rule."), (String)value);
            }
        });
        return map2;
    }
}

