/*
 * Decompiled with CFR 0.152.
 */
package minitweaks;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Rule;
import carpet.api.settings.Validator;
import carpet.api.settings.Validators;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;

public class MiniTweaksSettings {
    public static final String MODNAME = "minitweaks";
    public static final String MOBS = "mobs";
    public static final String ENCHANTMENT = "enchantment";
    public static final String BACKPORT = "backport";
    @Rule(categories={"minitweaks", "mobs"})
    public static boolean allChargedCreeperHeadsDrop;
    @Rule(categories={"minitweaks", "command"}, conditions={ServerSideOnlyRuleCondition.class})
    public static String commandSeed;
    @Rule(options={"5", "10", "15", "30", "-1"}, validators={ItemDespawnTimeValidator.class}, strict=false, categories={"minitweaks", "survival"})
    public static int deathItemsDespawnMinutes;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean disableBlazeFire;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean disableGhastFire;
    @Rule(categories={"minitweaks", "mobs", "dispenser"})
    public static boolean dispensersBucketMobs;
    @Rule(categories={"minitweaks", "mobs", "dispenser", "survival"})
    public static boolean dispensersCureVillagers;
    @Rule(categories={"minitweaks", "mobs", "dispenser"})
    public static boolean dispensersDuplicateAllays;
    @Rule(categories={"minitweaks", "mobs", "dispenser"})
    public static boolean dispensersDyeMobs;
    @Rule(categories={"minitweaks", "mobs", "dispenser"})
    public static boolean dispensersNameMobs;
    @Rule(categories={"minitweaks", "mobs", "dispenser"})
    public static boolean dispensersRepairGolems;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static BlockBreakingType dragonBlockDamage;
    @Rule(categories={"minitweaks", "mobs"})
    public static boolean dyeableShearedSheep;
    @Rule(categories={"minitweaks", "mobs"})
    public static boolean dyeableShulkers;
    @Rule(categories={"minitweaks", "feature"})
    public static boolean echoShardsEnableShriekers;
    @Rule(categories={"minitweaks", "survival", "feature"})
    public static boolean fasterOxidation;
    @Rule(categories={"minitweaks", "mobs"})
    public static boolean lightningGlowifiesSquids;
    @Rule(options={"0", "100", "1000", "10000"}, validators={Validators.NonNegativeNumber.class}, strict=false, categories={"minitweaks", "survival"})
    public static int maxPlayerXpDrop;
    @Rule(categories={"minitweaks", "mobs"})
    public static ItemPickupType mobItemPickup;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean mobsDropNametag;
    @Rule(categories={"minitweaks", "feature"})
    public static boolean moveableWaterloggedBlocks;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean noCreeperBlockBreaking;
    @Rule(categories={"minitweaks", "survival"})
    public static boolean noFeatherFallingTrample;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean noGhastBlockBreaking;
    @Rule(categories={"minitweaks", "mobs"})
    public static boolean noSnowGolemMelting;
    @Rule(categories={"minitweaks", "mobs"})
    public static boolean noVillagerWitchConversion;
    @Rule(options={"72000", "360000", "720000"}, validators={Validators.NonNegativeNumber.class}, strict=false, categories={"minitweaks", "mobs", "survival"})
    public static int phantomSpawningTime;
    @Rule(categories={"minitweaks", "survival", "feature"})
    public static boolean quickHarvesting;
    @Rule(categories={"minitweaks", "enchantment", "survival"})
    public static boolean removableCurses;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean renewableDragonEgg;
    @Rule(categories={"minitweaks", "survival", "feature"})
    public static boolean renewableRawOres;
    @Rule(categories={"minitweaks", "survival", "feature"})
    public static boolean shaveSnowLayers;
    @Rule(categories={"minitweaks", "mobs", "enchantment", "survival"})
    public static boolean slimeLooting;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean vexesNerf;
    @Rule(categories={"minitweaks", "mobs", "survival"})
    public static boolean villagersAlwaysConvert;
    @Rule(categories={"minitweaks", "mobs"})
    public static boolean villagersExplodeBeds;

    static {
        commandSeed = "ops";
        deathItemsDespawnMinutes = 5;
        disableBlazeFire = false;
        disableGhastFire = false;
        dispensersBucketMobs = false;
        dispensersCureVillagers = false;
        dispensersDuplicateAllays = false;
        dispensersDyeMobs = false;
        dispensersNameMobs = false;
        dispensersRepairGolems = false;
        dragonBlockDamage = BlockBreakingType.DEFAULT;
        dyeableShearedSheep = false;
        dyeableShulkers = false;
        echoShardsEnableShriekers = false;
        fasterOxidation = false;
        lightningGlowifiesSquids = false;
        maxPlayerXpDrop = 100;
        mobItemPickup = ItemPickupType.DEFAULT;
        mobsDropNametag = false;
        moveableWaterloggedBlocks = false;
        noCreeperBlockBreaking = false;
        noFeatherFallingTrample = false;
        noGhastBlockBreaking = false;
        noSnowGolemMelting = false;
        noVillagerWitchConversion = false;
        phantomSpawningTime = 72000;
        quickHarvesting = false;
        removableCurses = false;
        renewableDragonEgg = false;
        renewableRawOres = false;
        shaveSnowLayers = false;
        slimeLooting = false;
        vexesNerf = false;
        villagersAlwaysConvert = false;
        villagersExplodeBeds = false;
    }

    public static enum BlockBreakingType {
        DEFAULT,
        NONE,
        BREAK,
        DESTROY;

    }

    public static enum ItemPickupType {
        DEFAULT,
        ALWAYS,
        NEVER;

    }

    private static class ItemDespawnTimeValidator
    extends Validator<Integer> {
        private ItemDespawnTimeValidator() {
        }

        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String typedString) {
            if (newValue >= -1 && newValue <= 32) {
                return newValue;
            }
            return null;
        }
    }

    private static class ServerSideOnlyRuleCondition
    implements Rule.Condition {
        private ServerSideOnlyRuleCondition() {
        }

        public boolean shouldRegister() {
            return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
        }
    }
}

