/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek;

import ict.minesunshineone.peek.command.PeekCommand;
import ict.minesunshineone.peek.data.PeekData;
import ict.minesunshineone.peek.handler.PeekStateHandler;
import ict.minesunshineone.peek.handler.PeekTargetHandler;
import ict.minesunshineone.peek.listener.PeekInteractionListener;
import ict.minesunshineone.peek.listener.PeekListener;
import ict.minesunshineone.peek.listener.PeekPacketListener;
import ict.minesunshineone.peek.manager.CooldownManager;
import ict.minesunshineone.peek.manager.PrivacyManager;
import ict.minesunshineone.peek.manager.StateManager;
import ict.minesunshineone.peek.manager.StatisticsManager;
import ict.minesunshineone.peek.placeholder.PeekPlaceholderExpansion;
import ict.minesunshineone.peek.util.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PeekPlugin
extends JavaPlugin {
    private Messages messages;
    private StateManager stateManager;
    private PeekStateHandler stateHandler;
    private PeekTargetHandler targetHandler;
    private CooldownManager cooldownManager;
    private PrivacyManager privacyManager;
    private StatisticsManager statisticsManager;
    private PeekPacketListener packetListener;

    public void onEnable() {
        this.saveDefaultConfig();
        this.validateConfig();
        this.messages = new Messages(this);
        this.stateManager = new StateManager(this);
        this.stateHandler = new PeekStateHandler(this);
        this.targetHandler = new PeekTargetHandler(this);
        this.cooldownManager = new CooldownManager(this);
        this.privacyManager = new PrivacyManager(this);
        this.statisticsManager = new StatisticsManager(this);
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            this.packetListener = new PeekPacketListener(this);
            this.getLogger().info("\u5df2\u542f\u7528ProtocolLib\u652f\u6301\uff01");
        }
        PeekCommand peekCommand = new PeekCommand(this);
        PluginCommand cmd = this.getCommand("peek");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)peekCommand);
            cmd.setTabCompleter((TabCompleter)peekCommand);
        } else {
            this.getLogger().severe("\u65e0\u6cd5\u6ce8\u518c peek \u547d\u4ee4\uff0c\u8bf7\u68c0\u67e5 plugin.yml \u914d\u7f6e");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PeekListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PeekInteractionListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PeekPlaceholderExpansion(this).register();
        }
        this.getLogger().info("Peek\u63d2\u4ef6\u5df2\u542f\u7528\uff01");
    }

    public void onDisable() {
        if (this.stateHandler != null) {
            new HashMap<UUID, PeekData>(this.stateHandler.getActivePeeks()).forEach((uuid, data) -> {
                Player player = this.getServer().getPlayer(uuid);
                if (player != null && player.isOnline()) {
                    this.stateHandler.endPeek(player, true);
                }
            });
        }
        if (this.statisticsManager != null) {
            this.statisticsManager.saveStats();
        }
        if (this.privacyManager != null) {
            this.privacyManager.savePrivacyStates();
        }
        if (this.packetListener != null) {
            this.packetListener.unregisterPacketListeners();
        }
        this.getLogger().info("Peek\u63d2\u4ef6\u5df2\u7981\u7528\uff01");
    }

    private void validateConfig() {
        FileConfiguration config = this.getConfig();
        boolean needsSave = false;
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("language", "zh_CN");
        defaults.put("limits.cooldowns", 60);
        defaults.put("statistics.enabled", true);
        defaults.put("statistics.save-interval", 600);
        defaults.put("debug", false);
        defaults.put("limits.max-peek-distance", 50.0);
        defaults.put("limits.block-container-interaction", false);
        defaults.put("privacy.request-timeout", 30);
        defaults.put("privacy.cooldown.enabled", true);
        defaults.put("privacy.cooldown.duration", 60);
        defaults.put("sounds.start-peek", "BLOCK_NOTE_BLOCK_PLING");
        defaults.put("sounds.end-peek", "BLOCK_NOTE_BLOCK_BASS");
        defaults.put("privacy.sounds.request", "BLOCK_NOTE_BLOCK_PLING");
        defaults.put("privacy.sounds.accept", "ENTITY_PLAYER_LEVELUP");
        defaults.put("privacy.sounds.deny", "ENTITY_VILLAGER_NO");
        for (Map.Entry entry : defaults.entrySet()) {
            if (config.contains((String)entry.getKey())) continue;
            config.set((String)entry.getKey(), entry.getValue());
            needsSave = true;
        }
        ConfigurationSection soundsSection = config.getConfigurationSection("sounds");
        if (soundsSection != null) {
            for (String key : soundsSection.getKeys(false)) {
                String soundName = config.getString("sounds." + key);
                try {
                    Sound.valueOf((String)soundName);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning(String.format("\u914d\u7f6e\u4e2d\u5b58\u5728\u65e0\u6548\u7684\u97f3\u6548\u540d\u79f0\uff1a%s", soundName));
                    config.set("sounds." + key, defaults.get("sounds." + key));
                    needsSave = true;
                }
            }
        }
        if (needsSave) {
            this.saveConfig();
        }
    }

    public Messages getMessages() {
        return this.messages;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public PeekStateHandler getStateHandler() {
        return this.stateHandler;
    }

    public PeekTargetHandler getTargetHandler() {
        return this.targetHandler;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public PrivacyManager getPrivacyManager() {
        return this.privacyManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }
}

