/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.command;

import ict.minesunshineone.peek.PeekPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PeekCommand
implements CommandExecutor,
TabCompleter {
    private final PeekPlugin plugin;

    public PeekCommand(PeekPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessages().send(sender, "command-player-only", new String[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("peek.use")) {
            this.plugin.getMessages().send(player, "no-permission", new String[0]);
            return true;
        }
        if (args.length == 0) {
            this.plugin.getMessages().send(player, "usage", new String[0]);
            return true;
        }
        return switch (args[0].toLowerCase()) {
            case "exit" -> this.handleExit(player);
            case "stats" -> this.handleStats(player);
            case "privacy" -> this.handlePrivacy(player);
            case "accept" -> this.handleAccept(player);
            case "deny" -> this.handleDeny(player);
            default -> this.handlePeek(player, args[0]);
        };
    }

    private boolean handlePeek(Player peeker, String targetName) {
        if (!this.plugin.getTargetHandler().canPeek(peeker, targetName)) {
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(targetName);
        if (target == null) {
            this.plugin.getMessages().send(peeker, "player-not-found", "player", targetName);
            return true;
        }
        this.plugin.getStateHandler().startPeek(peeker, target);
        return true;
    }

    private boolean handleExit(Player player) {
        this.plugin.getStateHandler().endPeek(player);
        return true;
    }

    private boolean handleStats(Player player) {
        if (!player.hasPermission("peek.stats")) {
            this.plugin.getMessages().send(player, "no-permission", new String[0]);
            return true;
        }
        this.plugin.getStatisticsManager().showStats(player);
        return true;
    }

    private boolean handlePrivacy(Player player) {
        this.plugin.getPrivacyManager().togglePrivateMode(player);
        return true;
    }

    private boolean handleAccept(Player player) {
        this.plugin.getPrivacyManager().handleAccept(player);
        return true;
    }

    private boolean handleDeny(Player player) {
        this.plugin.getPrivacyManager().handleDeny(player);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("exit");
            completions.add("stats");
            completions.add("privacy");
            completions.add("accept");
            completions.add("deny");
            if (sender.hasPermission("peek.use")) {
                this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> !name.equals(sender.getName())).forEach(completions::add);
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

