/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.potion.PotionEffect;

public class PeekData {
    private final Location originalLocation;
    private final GameMode originalGameMode;
    private final UUID targetUUID;
    private final long startTime;
    private final double health;
    private final int foodLevel;
    private final float saturation;
    private final Collection<PotionEffect> potionEffects;
    private boolean exiting;

    public PeekData(Location originalLocation, GameMode originalGameMode, UUID targetUUID, long startTime, double health, int foodLevel, float saturation, Collection<PotionEffect> potionEffects) {
        this.originalLocation = originalLocation;
        this.originalGameMode = originalGameMode;
        this.targetUUID = targetUUID;
        this.startTime = startTime;
        this.health = health;
        this.foodLevel = foodLevel;
        this.saturation = saturation;
        this.potionEffects = new ArrayList<PotionEffect>(potionEffects);
        this.exiting = false;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    public GameMode getOriginalGameMode() {
        return this.originalGameMode;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isExiting() {
        return this.exiting;
    }

    public void setExiting(boolean exiting) {
        this.exiting = exiting;
    }

    public double getHealth() {
        return this.health;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public Collection<PotionEffect> getPotionEffects() {
        return Collections.unmodifiableCollection(this.potionEffects);
    }

    public float getSaturation() {
        return this.saturation;
    }
}

