/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.handler;

import ict.minesunshineone.peek.PeekPlugin;
import ict.minesunshineone.peek.data.PeekData;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PeekStateHandler {
    private final PeekPlugin plugin;
    private final Map<UUID, PeekData> activePeeks = new HashMap<UUID, PeekData>();
    private final Map<UUID, ScheduledTask> rangeCheckers = new HashMap<UUID, ScheduledTask>();
    private final Object rangeCheckersLock = new Object();
    private final double maxPeekDistance;

    public PeekStateHandler(PeekPlugin plugin) {
        this.plugin = plugin;
        this.maxPeekDistance = plugin.getConfig().getDouble("limits.max-peek-distance", 50.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPeek(Player peeker, Player target) {
        if (peeker == null || target == null) {
            this.plugin.getLogger().warning("\u5c1d\u8bd5\u5bf9\u7a7a\u73a9\u5bb6\u4f7f\u7528\u8d34\u8d34\u529f\u80fd");
            return;
        }
        if (peeker.isDead()) {
            this.plugin.getMessages().send(peeker, "cannot-peek-while-dead", new String[0]);
            return;
        }
        Map<UUID, PeekData> map = this.activePeeks;
        synchronized (map) {
            if (this.activePeeks.containsKey(peeker.getUniqueId())) {
                this.plugin.getMessages().send(peeker, "already-peeking", new String[0]);
                return;
            }
            this.logDebug("Starting peek: %s -> %s", peeker.getName(), target.getName());
            PeekData data = new PeekData(peeker.getLocation().clone(), peeker.getGameMode(), target.getUniqueId(), System.currentTimeMillis(), peeker.getHealth(), peeker.getFoodLevel(), peeker.getSaturation(), peeker.getActivePotionEffects());
            this.activePeeks.put(peeker.getUniqueId(), data);
            this.plugin.getStateManager().savePlayerState(peeker, data);
            this.plugin.getStatisticsManager().recordPeekStart(peeker, target);
            this.teleportAndSetGameMode(peeker, target);
        }
        this.plugin.getMessages().send(peeker, "peek-start", "player", target.getName());
        this.plugin.getMessages().send(target, "being-peeked", "player", peeker.getName());
        this.playSound(target, "start-peek");
        this.updateActionBar(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPeek(Player peeker, boolean shouldRestore) {
        if (peeker == null) {
            this.plugin.getLogger().warning("\u5c1d\u8bd5\u5bf9\u7a7a\u73a9\u5bb6\u7ed3\u675f\u8d34\u8d34\u529f\u80fd");
            return;
        }
        Map<UUID, PeekData> map = this.activePeeks;
        synchronized (map) {
            PeekData data = this.activePeeks.get(peeker.getUniqueId());
            if (data == null) {
                return;
            }
            if (data.isExiting()) {
                return;
            }
            data.setExiting(true);
            Player target = this.plugin.getServer().getPlayer(data.getTargetUUID());
            long duration = (System.currentTimeMillis() - data.getStartTime()) / 1000L;
            this.plugin.getStatisticsManager().recordPeekEnd(peeker, duration);
            this.plugin.getCooldownManager().setCooldown(peeker);
            this.stopRangeChecker(peeker);
            if (shouldRestore && peeker.isOnline()) {
                if (peeker.isDead()) {
                    this.plugin.getServer().getRegionScheduler().runAtFixedRate((Plugin)this.plugin, peeker.getLocation(), task -> {
                        if (!peeker.isOnline()) {
                            task.cancel();
                            return;
                        }
                        if (!peeker.isDead()) {
                            task.cancel();
                            this.restorePlayerState(peeker, data);
                            this.plugin.getStateManager().clearPlayerState(peeker);
                            this.plugin.getMessages().send(peeker, "peek-end-respawn", new String[0]);
                        }
                    }, 1L, 20L);
                } else {
                    this.restorePlayerState(peeker, data);
                }
            }
            if (shouldRestore && !peeker.isDead()) {
                this.plugin.getStateManager().clearPlayerState(peeker);
            }
            if (peeker.isOnline()) {
                this.plugin.getMessages().send(peeker, "peek-end", new String[0]);
            }
            if (target != null && target.isOnline()) {
                this.plugin.getMessages().send(target, "peek-end-target", "player", peeker.getName());
                this.playSound(target, "end-peek");
            }
            this.activePeeks.remove(peeker.getUniqueId());
            if (target != null && target.isOnline()) {
                this.updateActionBar(target);
            }
        }
    }

    public void endPeek(Player peeker) {
        this.endPeek(peeker, true);
    }

    private void teleportAndSetGameMode(Player peeker, Player target) {
        this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, peeker.getLocation(), task -> {
            try {
                if (peeker.isSleeping()) {
                    peeker.wakeup(false);
                }
                if (peeker.getGameMode() == GameMode.SPECTATOR && peeker.getSpectatorTarget() != null) {
                    peeker.setSpectatorTarget(null);
                }
                peeker.setGameMode(GameMode.SPECTATOR);
                peeker.teleportAsync(target.getLocation()).thenAccept(success -> {
                    if (!success.booleanValue()) {
                        this.plugin.getMessages().send(peeker, "teleport-failed", new String[0]);
                        this.endPeek(peeker);
                    } else {
                        this.startRangeChecker(peeker, target);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning(String.format("\u4e3a\u73a9\u5bb6 %s \u5207\u6362\u6e38\u620f\u6a21\u5f0f\u65f6\u53d1\u751f\u9519\u8bef", peeker.getName()));
                this.endPeek(peeker);
            }
        });
    }

    public void restorePlayerState(Player peeker, PeekData data) {
        this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, data.getOriginalLocation(), task -> {
            if (peeker.getGameMode() == GameMode.SPECTATOR && peeker.getSpectatorTarget() != null) {
                peeker.setSpectatorTarget(null);
            }
            peeker.setVelocity(new Vector(0, 0, 0));
            peeker.teleportAsync(data.getOriginalLocation()).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, data.getOriginalLocation(), modeTask -> {
                        peeker.setVelocity(new Vector(0, 0, 0));
                        peeker.setGameMode(data.getOriginalGameMode());
                        peeker.setHealth(Math.min(data.getHealth(), 20.0));
                        peeker.setFoodLevel(data.getFoodLevel());
                        peeker.setSaturation(data.getSaturation());
                        peeker.getActivePotionEffects().forEach(effect -> peeker.removePotionEffect(effect.getType()));
                        data.getPotionEffects().forEach(effect -> peeker.addPotionEffect(effect));
                    });
                } else {
                    Location spawnLoc;
                    this.plugin.getLogger().warning(String.format("\u65e0\u6cd5\u5c06\u73a9\u5bb6 %s \u4f20\u9001\u56de\u539f\u4f4d\u7f6e\uff0c\u6b63\u5728\u5c1d\u8bd5\u4f20\u9001\u5230\u91cd\u751f\u70b9", peeker.getName()));
                    Location location = spawnLoc = peeker.getBedSpawnLocation() != null ? peeker.getBedSpawnLocation() : peeker.getWorld().getSpawnLocation();
                    if (spawnLoc != null) {
                        this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, spawnLoc, spawnTask -> peeker.teleportAsync(spawnLoc).thenAccept(spawnSuccess -> {
                            if (spawnSuccess.booleanValue()) {
                                this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, spawnLoc, modeTask -> peeker.setGameMode(data.getOriginalGameMode()));
                            } else {
                                this.plugin.getLogger().severe(String.format("\u65e0\u6cd5\u5c06\u73a9\u5bb6 %s \u4f20\u9001\u5230\u4efb\u4f55\u5b89\u5168\u4f4d\u7f6e", peeker.getName()));
                            }
                        }));
                    }
                    this.plugin.getMessages().send(peeker, "teleport-failed", new String[0]);
                }
            });
        });
    }

    public Map<UUID, PeekData> getActivePeeks() {
        return Collections.unmodifiableMap(this.activePeeks);
    }

    private void logDebug(String message, Object ... args) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            this.plugin.getLogger().info(String.format(message, args));
        }
    }

    private void playSound(Player player, String soundKey) {
        String soundName = this.plugin.getConfig().getString("sounds." + soundKey);
        if (soundName != null) {
            try {
                Sound sound = Sound.valueOf((String)soundName);
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning(String.format("\u65e0\u6548\u7684\u97f3\u6548\u540d\u79f0\uff1a%s", soundName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRangeChecker(Player peeker, Player target) {
        Object object = this.rangeCheckersLock;
        synchronized (object) {
            this.stopRangeChecker(peeker);
            ScheduledTask task = this.plugin.getServer().getRegionScheduler().runAtFixedRate((Plugin)this.plugin, target.getLocation(), scheduledTask -> {
                if (!target.isOnline()) {
                    this.endPeek(peeker);
                    return;
                }
                try {
                    if (peeker.isDead()) {
                        return;
                    }
                    if (peeker.getWorld().equals((Object)target.getWorld())) {
                        double distance = peeker.getLocation().distance(target.getLocation());
                        if (distance > this.maxPeekDistance) {
                            this.plugin.getMessages().send(peeker, "range-exceeded", new String[0]);
                            this.endPeek(peeker);
                        }
                    } else {
                        this.plugin.getMessages().send(peeker, "target-in-different-world", new String[0]);
                        this.teleportAndSetGameMode(peeker, target);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning(String.format("\u8ddd\u79bb\u68c0\u67e5\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s", e.getMessage()));
                    this.endPeek(peeker);
                }
            }, 1L, 10L);
            this.rangeCheckers.put(peeker.getUniqueId(), task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRangeChecker(Player peeker) {
        Object object = this.rangeCheckersLock;
        synchronized (object) {
            ScheduledTask task = this.rangeCheckers.remove(peeker.getUniqueId());
            if (task != null) {
                task.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.rangeCheckersLock;
        synchronized (object) {
            new HashMap<UUID, ScheduledTask>(this.rangeCheckers).forEach((peeker, task) -> {
                task.cancel();
                this.rangeCheckers.remove(peeker);
            });
        }
    }

    public void removeActivePeek(Player player) {
        this.activePeeks.remove(player.getUniqueId());
    }

    public long getPeekerCount(UUID targetUUID) {
        return this.activePeeks.values().stream().filter(data -> data.getTargetUUID().equals(targetUUID)).count();
    }

    public void updateActionBar(Player target) {
        long peekerCount = this.getPeekerCount(target.getUniqueId());
        if (peekerCount > 0L) {
            this.plugin.getMessages().sendActionBar(target, "being-peeked-actionbar", "count", String.valueOf(peekerCount));
        }
    }
}

