/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.handler;

import ict.minesunshineone.peek.PeekPlugin;
import org.bukkit.entity.Player;

public class PeekTargetHandler {
    private final PeekPlugin plugin;

    public PeekTargetHandler(PeekPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean canPeek(Player peeker, String targetName) {
        Player target = this.plugin.getServer().getPlayer(targetName);
        if (target == null || !target.isOnline()) {
            this.plugin.getMessages().send(peeker, "player-not-found", "player", targetName);
            return false;
        }
        if (peeker.equals((Object)target)) {
            this.plugin.getMessages().send(peeker, "cannot-peek-self", new String[0]);
            return false;
        }
        if (this.plugin.getStateHandler().getActivePeeks().containsKey(target.getUniqueId())) {
            this.plugin.getMessages().send(peeker, "target-is-peeking", new String[0]);
            return false;
        }
        if (this.plugin.getCooldownManager().isOnCooldown(peeker)) {
            this.plugin.getMessages().send(peeker, "cooldown-peek", "time", String.valueOf(this.plugin.getCooldownManager().getRemainingCooldown(peeker)));
            return false;
        }
        if (this.plugin.getPrivacyManager().isPrivateMode(target)) {
            this.plugin.getPrivacyManager().sendPeekRequest(peeker, target);
            return false;
        }
        return true;
    }
}

