/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.listener;

import ict.minesunshineone.peek.PeekPlugin;
import ict.minesunshineone.peek.data.PeekData;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PeekListener
implements Listener {
    private final PeekPlugin plugin;

    public PeekListener(PeekPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getStateHandler().getActivePeeks().containsKey(player.getUniqueId())) {
            this.plugin.getStateHandler().removeActivePeek(player);
            this.plugin.getStateHandler().stopRangeChecker(player);
        }
        for (Map.Entry<UUID, PeekData> entry : new HashMap<UUID, PeekData>(this.plugin.getStateHandler().getActivePeeks()).entrySet()) {
            Player peeker;
            if (!player.getUniqueId().equals(entry.getValue().getTargetUUID()) || (peeker = this.plugin.getServer().getPlayer(entry.getKey())) == null) continue;
            this.plugin.getStateHandler().endPeek(peeker);
        }
        this.plugin.getPrivacyManager().cancelAllRequests(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PeekData savedState = this.plugin.getStateManager().getPlayerState(player);
        if (savedState != null) {
            this.plugin.getServer().getRegionScheduler().runAtFixedRate((Plugin)this.plugin, player.getLocation(), task -> {
                if (!player.isOnline()) {
                    task.cancel();
                    return;
                }
                if (!player.isDead()) {
                    task.cancel();
                    this.plugin.getStateHandler().restorePlayerState(player, savedState);
                    this.plugin.getStateManager().clearPlayerState(player);
                    this.plugin.getMessages().send(player, "peek-end-offline", new String[0]);
                }
            }, 1L, 20L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        for (Map.Entry<UUID, Map<UUID, ScheduledTask>> entry : new HashMap<UUID, Map<UUID, ScheduledTask>>(this.plugin.getPrivacyManager().getPendingRequests()).entrySet()) {
            Map<UUID, ScheduledTask> requests = entry.getValue();
            if (!requests.containsKey(player.getUniqueId())) continue;
            Player target = this.plugin.getServer().getPlayer(entry.getKey());
            this.plugin.getPrivacyManager().removePendingRequest(player, target);
            this.plugin.getMessages().send(player, "request-cancelled-death", new String[0]);
            if (target == null || !target.isOnline()) continue;
            this.plugin.getMessages().send(target, "request-cancelled-death-target", new String[0]);
        }
    }
}

