/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import ict.minesunshineone.peek.PeekPlugin;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PeekPacketListener {
    private final PeekPlugin plugin;
    private final ProtocolManager protocolManager;

    public PeekPacketListener(PeekPlugin plugin) {
        this.plugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.registerPacketListeners();
    }

    private void registerPacketListeners() {
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, new PacketType[]{PacketType.Play.Client.SPECTATE}){

            public void onPacketReceiving(PacketEvent event) {
                Player player = event.getPlayer();
                if (((PeekPlugin)this.plugin).getStateHandler().getActivePeeks().containsKey(player.getUniqueId()) && player.getGameMode() == GameMode.SPECTATOR) {
                    event.setCancelled(true);
                }
            }
        });
    }

    public void unregisterPacketListeners() {
        this.protocolManager.removePacketListeners((Plugin)this.plugin);
    }
}

