/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.manager;

import ict.minesunshineone.peek.PeekPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final int cooldownDuration;

    public CooldownManager(PeekPlugin plugin) {
        this.cooldownDuration = plugin.getConfig().getInt("limits.cooldowns", 60);
    }

    public void setCooldown(Player player) {
        if (!player.hasPermission("peek.nocooldown")) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    public boolean isOnCooldown(Player player) {
        if (player.hasPermission("peek.nocooldown")) {
            return false;
        }
        Long lastUsage = this.cooldowns.get(player.getUniqueId());
        if (lastUsage == null) {
            return false;
        }
        return System.currentTimeMillis() - lastUsage < (long)this.cooldownDuration * 1000L;
    }

    public int getRemainingCooldown(Player player) {
        if (player.hasPermission("peek.nocooldown")) {
            return 0;
        }
        Long lastUsage = this.cooldowns.get(player.getUniqueId());
        if (lastUsage == null) {
            return 0;
        }
        long remaining = (lastUsage + (long)this.cooldownDuration * 1000L - System.currentTimeMillis()) / 1000L;
        return Math.max(0, (int)remaining);
    }

    public void clearCooldown(Player player) {
        this.cooldowns.remove(player.getUniqueId());
    }
}

