/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.manager;

import ict.minesunshineone.peek.PeekPlugin;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PrivacyManager {
    private final PeekPlugin plugin;
    private final Set<UUID> privateModeUsers = new HashSet<UUID>();
    private final Map<UUID, Map<UUID, ScheduledTask>> pendingRequests = new HashMap<UUID, Map<UUID, ScheduledTask>>();
    private final Map<String, Long> requestCooldowns = new HashMap<String, Long>();
    private final int requestTimeout;
    private final boolean cooldownEnabled;
    private final int cooldownDuration;
    private final File privacyFile;
    private final YamlConfiguration privacyConfig;

    public PrivacyManager(PeekPlugin plugin) {
        this.plugin = plugin;
        this.requestTimeout = plugin.getConfig().getInt("privacy.request-timeout", 30);
        this.cooldownEnabled = plugin.getConfig().getBoolean("privacy.cooldown.enabled", true);
        this.cooldownDuration = plugin.getConfig().getInt("privacy.cooldown.duration", 60);
        this.privacyFile = new File(plugin.getDataFolder(), "privacy.yml");
        this.privacyConfig = YamlConfiguration.loadConfiguration((File)this.privacyFile);
        this.loadPrivacyStates();
    }

    private void loadPrivacyStates() {
        List uuids = this.privacyConfig.getStringList("private_mode_players");
        this.privateModeUsers.clear();
        for (String uuid : uuids) {
            try {
                this.privateModeUsers.add(UUID.fromString(uuid));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning(String.format("\u65e0\u6548\u7684UUID\u683c\u5f0f: %s", uuid));
            }
        }
    }

    public void savePrivacyStates() {
        List uuids = this.privateModeUsers.stream().map(UUID::toString).collect(Collectors.toList());
        this.privacyConfig.set("private_mode_players", uuids);
        try {
            this.privacyConfig.save(this.privacyFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning(String.format("\u65e0\u6cd5\u4fdd\u5b58\u79c1\u4eba\u6a21\u5f0f\u72b6\u6001: %s", e.getMessage()));
        }
    }

    public boolean isPrivateMode(Player player) {
        return this.privateModeUsers.contains(player.getUniqueId());
    }

    public void togglePrivateMode(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.privateModeUsers.contains(uuid)) {
            this.privateModeUsers.remove(uuid);
            this.plugin.getMessages().send(player, "privacy-mode-disabled", new String[0]);
        } else {
            this.privateModeUsers.add(uuid);
            this.plugin.getMessages().send(player, "privacy-mode-enabled", new String[0]);
        }
        this.savePrivacyStates();
    }

    public void sendPeekRequest(Player peeker, Player target) {
        if (!target.isOnline()) {
            this.plugin.getMessages().send(peeker, "target-offline", new String[0]);
            return;
        }
        if (this.plugin.getStateHandler().getActivePeeks().containsKey(target.getUniqueId())) {
            this.plugin.getMessages().send(peeker, "target-is-peeking", new String[0]);
            return;
        }
        UUID peekerUuid = peeker.getUniqueId();
        UUID targetUuid = target.getUniqueId();
        if (this.isOnRequestCooldown(peeker, target)) {
            this.plugin.getMessages().send(peeker, "request-cooldown", "time", String.valueOf(this.getRemainingRequestCooldown(peeker, target)));
            return;
        }
        if (this.hasPendingRequest(peeker, target)) {
            this.plugin.getMessages().send(peeker, "request-already-pending", new String[0]);
            return;
        }
        this.plugin.getMessages().send(target, "peek-request", "player", peeker.getName());
        this.plugin.getMessages().send(peeker, "request-sent", "player", target.getName());
        this.playSound(target, "privacy.sounds.request");
        ScheduledTask timeoutTask = this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, target.getLocation(), task -> {
            if (this.removePendingRequest(peeker, target)) {
                this.plugin.getMessages().send(peeker, "request-timeout", new String[0]);
                this.plugin.getMessages().send(target, "request-timeout-target", new String[0]);
                this.setRequestCooldown(peeker, target);
            }
        }, (long)this.requestTimeout * 20L);
        this.pendingRequests.computeIfAbsent(targetUuid, k -> new HashMap()).put(peekerUuid, timeoutTask);
    }

    public void handleRequestResponse(Player target, Player peeker, boolean accepted) {
        if (!this.hasPendingRequest(peeker, target)) {
            this.plugin.getMessages().send(target, "no-pending-request", new String[0]);
            return;
        }
        this.removePendingRequest(peeker, target);
        if (accepted) {
            this.playSound(peeker, "privacy.sounds.accept");
            this.plugin.getStateHandler().startPeek(peeker, target);
        } else {
            this.playSound(peeker, "privacy.sounds.deny");
            this.plugin.getMessages().send(peeker, "request-denied", new String[0]);
            this.setRequestCooldown(peeker, target);
        }
    }

    private boolean hasPendingRequest(Player peeker, Player target) {
        Map<UUID, ScheduledTask> targetRequests = this.pendingRequests.get(target.getUniqueId());
        return targetRequests != null && targetRequests.containsKey(peeker.getUniqueId());
    }

    public boolean removePendingRequest(Player peeker, Player target) {
        ScheduledTask task;
        Map<UUID, ScheduledTask> targetRequests = this.pendingRequests.get(target.getUniqueId());
        if (targetRequests != null && (task = targetRequests.remove(peeker.getUniqueId())) != null) {
            task.cancel();
            if (targetRequests.isEmpty()) {
                this.pendingRequests.remove(target.getUniqueId());
            }
            return true;
        }
        return false;
    }

    private void setRequestCooldown(Player peeker, Player target) {
        if (this.cooldownEnabled) {
            String key = this.getCooldownKey(peeker.getUniqueId(), target.getUniqueId());
            this.requestCooldowns.put(key, System.currentTimeMillis());
        }
    }

    private boolean isOnRequestCooldown(Player peeker, Player target) {
        if (!this.cooldownEnabled || peeker.hasPermission("peek.nocooldown")) {
            return false;
        }
        String key = this.getCooldownKey(peeker.getUniqueId(), target.getUniqueId());
        Long lastRequest = this.requestCooldowns.get(key);
        if (lastRequest == null) {
            return false;
        }
        return System.currentTimeMillis() - lastRequest < (long)this.cooldownDuration * 1000L;
    }

    private int getRemainingRequestCooldown(Player peeker, Player target) {
        if (!this.cooldownEnabled || peeker.hasPermission("peek.nocooldown")) {
            return 0;
        }
        String key = this.getCooldownKey(peeker.getUniqueId(), target.getUniqueId());
        Long lastRequest = this.requestCooldowns.get(key);
        if (lastRequest == null) {
            return 0;
        }
        long remaining = (lastRequest + (long)this.cooldownDuration * 1000L - System.currentTimeMillis()) / 1000L;
        return Math.max(0, (int)remaining);
    }

    private String getCooldownKey(UUID peeker, UUID target) {
        return peeker.toString() + "_" + target.toString();
    }

    private void playSound(Player player, String configPath) {
        String soundName = this.plugin.getConfig().getString(configPath);
        if (soundName != null) {
            try {
                Sound sound = Sound.valueOf((String)soundName);
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning(String.format("\u65e0\u6548\u7684\u58f0\u97f3\u540d\u79f0: %s", soundName));
            }
        }
    }

    public void cancelAllRequests(Player player) {
        UUID playerUuid = player.getUniqueId();
        Map<UUID, ScheduledTask> targetRequests = this.pendingRequests.remove(playerUuid);
        if (targetRequests != null) {
            targetRequests.values().forEach(ScheduledTask::cancel);
        }
        this.pendingRequests.values().forEach(requests -> {
            ScheduledTask task = (ScheduledTask)requests.remove(playerUuid);
            if (task != null) {
                task.cancel();
            }
        });
        this.pendingRequests.values().removeIf(Map::isEmpty);
    }

    public void handleAccept(Player player) {
        UUID playerUuid = player.getUniqueId();
        Map<UUID, ScheduledTask> requests = this.pendingRequests.get(playerUuid);
        if (requests == null || requests.isEmpty()) {
            this.plugin.getMessages().send(player, "no-pending-request", new String[0]);
            return;
        }
        Map.Entry<UUID, ScheduledTask> entry = requests.entrySet().iterator().next();
        Player peeker = this.plugin.getServer().getPlayer(entry.getKey());
        if (peeker == null || !peeker.isOnline()) {
            this.removePendingRequest(peeker, player);
            this.plugin.getMessages().send(player, "request-expired", new String[0]);
            return;
        }
        this.handleRequestResponse(player, peeker, true);
    }

    public void handleDeny(Player player) {
        UUID playerUuid = player.getUniqueId();
        Map<UUID, ScheduledTask> requests = this.pendingRequests.get(playerUuid);
        if (requests == null || requests.isEmpty()) {
            this.plugin.getMessages().send(player, "no-pending-request", new String[0]);
            return;
        }
        Map.Entry<UUID, ScheduledTask> entry = requests.entrySet().iterator().next();
        Player peeker = this.plugin.getServer().getPlayer(entry.getKey());
        if (peeker != null && peeker.isOnline()) {
            this.handleRequestResponse(player, peeker, false);
        } else {
            this.removePendingRequest(peeker, player);
            this.plugin.getMessages().send(player, "request-expired", new String[0]);
        }
    }

    public Map<UUID, Map<UUID, ScheduledTask>> getPendingRequests() {
        return this.pendingRequests;
    }
}

