/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.manager;

import ict.minesunshineone.peek.PeekPlugin;
import ict.minesunshineone.peek.data.PeekData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class StateManager {
    private final PeekPlugin plugin;
    private final File statesDir;

    public StateManager(PeekPlugin plugin) {
        this.plugin = plugin;
        this.statesDir = new File(plugin.getDataFolder(), "states");
        if (!this.statesDir.exists()) {
            this.statesDir.mkdirs();
        }
    }

    public void savePlayerState(Player player, PeekData data) {
        File stateFile = new File(this.statesDir, String.valueOf(player.getUniqueId()) + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        config.set("location", (Object)data.getOriginalLocation());
        config.set("gamemode", (Object)data.getOriginalGameMode().name());
        config.set("target", (Object)data.getTargetUUID().toString());
        config.set("startTime", (Object)data.getStartTime());
        config.set("health", (Object)data.getHealth());
        config.set("food_level", (Object)data.getFoodLevel());
        config.set("saturation", (Object)Float.valueOf(data.getSaturation()));
        ArrayList effects = new ArrayList();
        for (PotionEffect effect : data.getPotionEffects()) {
            HashMap<String, Object> effectMap = new HashMap<String, Object>();
            effectMap.put("type", effect.getType().getName());
            effectMap.put("duration", effect.getDuration());
            effectMap.put("amplifier", effect.getAmplifier());
            effectMap.put("ambient", effect.isAmbient());
            effectMap.put("particles", effect.hasParticles());
            effectMap.put("icon", effect.hasIcon());
            effects.add(effectMap);
        }
        config.set("potion_effects", effects);
        try {
            config.save(stateFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning(String.format("\u65e0\u6cd5\u4fdd\u5b58\u73a9\u5bb6 %s \u7684\u72b6\u6001", player.getName()));
        }
    }

    public PeekData getPlayerState(Player player) {
        File stateFile = new File(this.statesDir, String.valueOf(player.getUniqueId()) + ".yml");
        if (!stateFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)stateFile);
        try {
            Location location = (Location)config.get("location");
            GameMode gameMode = GameMode.valueOf((String)config.getString("gamemode"));
            UUID targetUUID = UUID.fromString(config.getString("target"));
            long startTime = config.getLong("startTime");
            double health = config.getDouble("health", 20.0);
            int foodLevel = config.getInt("food_level", 20);
            float saturation = (float)config.getDouble("saturation", 5.0);
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
            List effectsList = config.getMapList("potion_effects");
            for (Map effectMap : effectsList) {
                PotionEffectType type = PotionEffectType.getByName((String)((String)effectMap.get("type")));
                if (type == null) continue;
                effects.add(new PotionEffect(type, ((Number)effectMap.get("duration")).intValue(), ((Number)effectMap.get("amplifier")).intValue(), ((Boolean)effectMap.get("ambient")).booleanValue(), ((Boolean)effectMap.get("particles")).booleanValue(), ((Boolean)effectMap.get("icon")).booleanValue()));
            }
            return new PeekData(location, gameMode, targetUUID, startTime, health, foodLevel, saturation, effects);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(String.format("\u65e0\u6cd5\u52a0\u8f7d\u73a9\u5bb6 %s \u7684\u72b6\u6001: %s", player.getName(), e.getMessage()));
            return null;
        }
    }

    public void clearPlayerState(Player player) {
        File stateFile = new File(this.statesDir, String.valueOf(player.getUniqueId()) + ".yml");
        if (stateFile.exists()) {
            stateFile.delete();
        }
    }
}

