/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.manager;

import ict.minesunshineone.peek.PeekPlugin;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StatisticsManager {
    private final PeekPlugin plugin;
    private final Map<UUID, PlayerStats> stats = new ConcurrentHashMap<UUID, PlayerStats>();
    private final File statsFile;
    private ScheduledTask autoSaveTask;
    private final boolean enabled;

    public StatisticsManager(PeekPlugin plugin) {
        this.plugin = plugin;
        this.statsFile = new File(plugin.getDataFolder(), "stats.yml");
        this.enabled = plugin.getConfig().getBoolean("statistics.enabled", true);
        if (this.enabled) {
            this.loadStats();
            this.startAutoSave();
        }
    }

    public void recordPeekStart(Player peeker, Player target) {
        if (!this.enabled) {
            return;
        }
        this.stats.computeIfAbsent(peeker.getUniqueId(), k -> new PlayerStats()).incrementPeekCount();
        this.stats.computeIfAbsent(target.getUniqueId(), k -> new PlayerStats()).incrementPeekedCount();
    }

    public void recordPeekEnd(Player peeker, long durationSeconds) {
        if (!this.enabled || peeker == null) {
            return;
        }
        if (durationSeconds < 0L) {
            this.plugin.getLogger().warning(String.format("Negative peek duration detected for player %s: %d", peeker.getName(), durationSeconds));
            durationSeconds = 0L;
        }
        this.stats.computeIfAbsent(peeker.getUniqueId(), k -> new PlayerStats()).addPeekDuration(durationSeconds);
    }

    public PlayerStats getPlayerStats(Player player) {
        return this.stats.getOrDefault(player.getUniqueId(), new PlayerStats());
    }

    private void loadStats() {
        if (!this.statsFile.exists()) {
            return;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.statsFile);
            for (String uuidStr : config.getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    int peekCount = Math.max(0, config.getInt(uuidStr + ".peek_count", 0));
                    int peekedCount = Math.max(0, config.getInt(uuidStr + ".peeked_count", 0));
                    long totalDuration = Math.max(0L, config.getLong(uuidStr + ".total_duration", 0L));
                    PlayerStats playerStats = new PlayerStats();
                    playerStats.setPeekCount(peekCount);
                    playerStats.setPeekedCount(peekedCount);
                    playerStats.setTotalDuration(totalDuration);
                    this.stats.put(uuid, playerStats);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning(String.format("\u65e0\u6548\u7684 UUID: %s", uuidStr));
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("\u65e0\u6cd5\u52a0\u8f7d\u7edf\u8ba1\u6570\u636e: %s", e.getMessage()));
        }
    }

    public void saveStats() {
        if (!this.enabled) {
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        this.stats.forEach((arg_0, arg_1) -> StatisticsManager.lambda$saveStats$3((FileConfiguration)config, arg_0, arg_1));
        try {
            config.save(this.statsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe(String.format("\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u6570\u636e: %s", e.getMessage()));
        }
    }

    private void startAutoSave() {
        int saveInterval = this.plugin.getConfig().getInt("statistics.save-interval", 600);
        this.autoSaveTask = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.saveStats(), (long)saveInterval * 50L, (long)saveInterval * 50L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this.autoSaveTask != null) {
            this.autoSaveTask.cancel();
        }
        this.saveStats();
    }

    public void showStats(Player player) {
        if (!this.enabled) {
            this.plugin.getMessages().send(player, "stats-disabled", new String[0]);
            return;
        }
        PlayerStats playerStats = this.getPlayerStats(player);
        this.plugin.getMessages().send(player, "stats-self", "peek_count", String.valueOf(playerStats.getPeekCount()), "peeked_count", String.valueOf(playerStats.getPeekedCount()), "peek_duration", String.valueOf(playerStats.getTotalDuration() / 60L));
    }

    private static /* synthetic */ void lambda$saveStats$3(FileConfiguration config, UUID uuid, PlayerStats playerStats) {
        String path = uuid.toString();
        config.set(path + ".peek_count", (Object)playerStats.getPeekCount());
        config.set(path + ".peeked_count", (Object)playerStats.getPeekedCount());
        config.set(path + ".total_duration", (Object)playerStats.getTotalDuration());
    }

    public static class PlayerStats {
        private int peekCount;
        private int peekedCount;
        private long totalDuration;

        public void incrementPeekCount() {
            ++this.peekCount;
        }

        public void incrementPeekedCount() {
            ++this.peekedCount;
        }

        public void addPeekDuration(long seconds) {
            this.totalDuration += seconds;
        }

        public int getPeekCount() {
            return this.peekCount;
        }

        public void setPeekCount(int count) {
            this.peekCount = count;
        }

        public int getPeekedCount() {
            return this.peekedCount;
        }

        public void setPeekedCount(int count) {
            this.peekedCount = count;
        }

        public long getTotalDuration() {
            return this.totalDuration;
        }

        public void setTotalDuration(long duration) {
            this.totalDuration = duration;
        }
    }
}

