/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.placeholder;

import ict.minesunshineone.peek.PeekPlugin;
import ict.minesunshineone.peek.manager.StatisticsManager;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class PeekPlaceholderExpansion
extends PlaceholderExpansion {
    private final PeekPlugin plugin;

    public PeekPlaceholderExpansion(PeekPlugin plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "peek";
    }

    public String getAuthor() {
        return "MineSunshineOne";
    }

    public String getVersion() {
        return "${project.version}";
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null || identifier == null) {
            return "";
        }
        try {
            StatisticsManager.PlayerStats stats = this.plugin.getStatisticsManager().getPlayerStats(player);
            return switch (identifier) {
                case "peek_count" -> String.valueOf(stats.getPeekCount());
                case "peeked_count" -> String.valueOf(stats.getPeekedCount());
                case "total_duration" -> String.valueOf(stats.getTotalDuration());
                case "is_peeking" -> String.valueOf(this.plugin.getStateHandler().getActivePeeks().containsKey(player.getUniqueId()));
                case "is_private" -> String.valueOf(this.plugin.getPrivacyManager().isPrivateMode(player));
                default -> null;
            };
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(String.format("\u5904\u7406\u53d8\u91cf\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s", e.getMessage()));
            return "";
        }
    }
}

