/*
 * Decompiled with CFR 0.152.
 */
package ict.minesunshineone.peek.util;

import ict.minesunshineone.peek.PeekPlugin;
import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Messages {
    private final PeekPlugin plugin;
    private YamlConfiguration messages;

    public Messages(PeekPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        String language = this.plugin.getConfig().getString("language", "zh_CN");
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + language + ".yml");
        if (!langFile.exists()) {
            langFile.getParentFile().mkdirs();
            this.plugin.saveResource("lang/" + language + ".yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)langFile);
        if (!this.messages.contains("messages")) {
            this.plugin.getLogger().severe(String.format("\u65e0\u6cd5\u627e\u5230\u8bed\u8a00 %s \u7684\u6d88\u606f\u914d\u7f6e", language));
            this.messages = new YamlConfiguration();
            this.messages.createSection("messages");
        }
    }

    public void send(Player player, String key, String ... placeholders) {
        String message = this.messages.getString("messages." + key);
        if (message == null) {
            this.plugin.getLogger().warning(String.format("\u627e\u4e0d\u5230\u6d88\u606f\u952e\uff1a%s", key));
            return;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace("{" + placeholders[i] + "}", placeholders[i + 1]);
        }
        String prefix = this.messages.getString("messages.prefix", "");
        String fullMessage = prefix + message;
        player.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(fullMessage));
    }

    public void send(CommandSender sender, String key, String ... placeholders) {
        String message = this.messages.getString("messages." + key);
        if (message == null) {
            this.plugin.getLogger().warning(String.format("\u627e\u4e0d\u5230\u6d88\u606f\u952e\uff1a%s", key));
            return;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace("{" + placeholders[i] + "}", placeholders[i + 1]);
        }
        String prefix = this.messages.getString("messages.prefix", "");
        String fullMessage = prefix + message;
        sender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(fullMessage));
    }

    public String get(String key) {
        return this.messages.getString("messages." + key);
    }

    public void sendActionBar(Player player, String key, String ... placeholders) {
        String message = this.messages.getString("messages." + key);
        if (message == null) {
            return;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace("{" + placeholders[i] + "}", placeholders[i + 1]);
        }
        player.sendActionBar((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(message));
    }
}

