/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.item;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.temperature.TemperatureHelperImpl;

public class TemperatureProperty
implements RangeSelectItemModelProperty {
    public static final MapCodec<TemperatureProperty> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.INT, Delta.CODEC).fieldOf("deltas").forGetter(TemperatureProperty::deltas)).apply((Applicative)builder, TemperatureProperty::new));
    private final Map<Integer, Delta> deltas;

    public TemperatureProperty(Map<Integer, Delta> deltas) {
        this.deltas = Maps.newHashMap(deltas);
    }

    public TemperatureProperty() {
        this.deltas = new HashMap<Integer, Delta>();
    }

    public float get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int i) {
        LivingEntity holder;
        Object object = holder = entity != null ? entity : stack.getEntityRepresentation();
        if (holder == null) {
            return 0.5f;
        }
        if (level == null && holder.level() instanceof ClientLevel) {
            level = (ClientLevel)holder.level();
        }
        if (level == null) {
            return 0.5f;
        }
        Delta delta = this.deltas.computeIfAbsent(holder.getId(), k -> new Delta());
        delta.update(level, TemperatureProperty.getTemperatureForThermometer((Level)level, (Entity)holder));
        return delta.getValue();
    }

    public MapCodec<? extends RangeSelectItemModelProperty> type() {
        return CODEC;
    }

    private Map<Integer, Delta> deltas() {
        return this.deltas;
    }

    private static TemperatureLevel getTemperatureForThermometer(Level level, Entity holder) {
        TemperatureLevel temperatureLevel = TemperatureHelper.getTemperatureAtPos(level, holder.blockPosition());
        LocalPlayer player = Minecraft.getInstance().player;
        Set<BlockPos> nearbyThermoregulators = TemperatureHelper.getTemperatureData((Player)player).getNearbyThermoregulators();
        return TemperatureHelperImpl.modifyTemperatureByThermoregulators(level, nearbyThermoregulators, holder.blockPosition(), temperatureLevel);
    }

    private static class Delta {
        public static final Codec<Delta> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("last_update_tick").forGetter(Delta::lastUpdateTick), (App)Codec.DOUBLE.fieldOf("value").forGetter(Delta::currentValue), (App)Codec.DOUBLE.fieldOf("rota").forGetter(Delta::rota)).apply((Applicative)builder, Delta::new));
        private long lastUpdateTick;
        private double currentValue;
        private double rota;

        public Delta(long lastUpdateTick, double currentValue, double rota) {
            this.lastUpdateTick = lastUpdateTick;
            this.currentValue = currentValue;
            this.rota = rota;
        }

        public Delta() {
        }

        private void update(ClientLevel level, TemperatureLevel temperatureLevel) {
            if (level.getGameTime() == this.lastUpdateTick) {
                return;
            }
            this.lastUpdateTick = level.getGameTime();
            double targetValue = (double)temperatureLevel.ordinal() * 0.25;
            double delta = targetValue - this.currentValue;
            this.rota += delta * 0.1;
            this.rota *= 0.87;
            this.currentValue = Mth.clamp((double)(this.currentValue + this.rota), (double)0.0, (double)1.0);
        }

        public float getValue() {
            return (float)((double)Math.round(this.currentValue * 20.0) / 20.0);
        }

        private long lastUpdateTick() {
            return this.lastUpdateTick;
        }

        private double currentValue() {
            return this.currentValue;
        }

        private double rota() {
            return this.rota;
        }
    }
}

