/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.mixin.client;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toughasnails.api.item.TANItems;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack {
    @Shadow
    public abstract Item getItem();

    @Shadow
    @Nullable
    public abstract <T> T set(DataComponentType<T> var1, @Nullable T var2);

    @Inject(method={"inventoryTick"}, at={@At(value="TAIL")})
    public void onTick(Level level, Entity entity, @javax.annotation.Nullable EquipmentSlot slot, CallbackInfo ci) {
        if (!level.isClientSide()) {
            return;
        }
        Item item = this.getItem();
        if (item == TANItems.LEAF_BOOTS || item == TANItems.LEAF_LEGGINGS || item == TANItems.LEAF_CHESTPLATE || item == TANItems.LEAF_HELMET) {
            this.set(DataComponents.DYED_COLOR, new DyedItemColor(BiomeColors.getAverageFoliageColor((BlockAndTintGetter)entity.level(), (BlockPos)entity.blockPosition())));
        }
    }
}

