/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.neoforge.datagen;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import toughasnails.init.ModEnchantments;
import toughasnails.neoforge.datagen.ModDamageTypes;
import toughasnails.neoforge.datagen.loot.TANLootTableProvider;
import toughasnails.neoforge.datagen.model.TANEquipmentAssetProvider;
import toughasnails.neoforge.datagen.model.TANModelProvider;
import toughasnails.neoforge.datagen.provider.TANBiomeTagsProvider;
import toughasnails.neoforge.datagen.provider.TANBlockTagsProvider;
import toughasnails.neoforge.datagen.provider.TANDamageTypeTagsProvider;
import toughasnails.neoforge.datagen.provider.TANEnchantmentTagsProvider;
import toughasnails.neoforge.datagen.provider.TANItemTagsProvider;
import toughasnails.neoforge.datagen.provider.TANPoiTypesTagsProvider;
import toughasnails.neoforge.datagen.provider.TANRecipeProvider;
import toughasnails.neoforge.datagen.provider.TANTrimMaterialTagsProvider;

@EventBusSubscriber(modid="toughasnails")
public class DataGenerationHandler {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, ModDamageTypes::bootstrap).add(Registries.ENCHANTMENT, ModEnchantments::bootstrap);

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DatapackBuiltinEntriesProvider datapackProvider = (DatapackBuiltinEntriesProvider)generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, BUILDER, Set.of("toughasnails")));
        generator.addProvider(true, (DataProvider)new TANRecipeProvider.Runner(output, event.getLookupProvider()));
        generator.addProvider(true, (DataProvider)TANLootTableProvider.create(output, event.getLookupProvider()));
        TANBlockTagsProvider blocksTagProvider = (TANBlockTagsProvider)generator.addProvider(true, (DataProvider)new TANBlockTagsProvider(output, datapackProvider.getRegistryProvider()));
        generator.addProvider(true, (DataProvider)new TANItemTagsProvider(output, datapackProvider.getRegistryProvider()));
        generator.addProvider(true, (DataProvider)new TANBiomeTagsProvider(output, datapackProvider.getRegistryProvider()));
        generator.addProvider(true, (DataProvider)new TANDamageTypeTagsProvider(output, datapackProvider.getRegistryProvider()));
        generator.addProvider(true, (DataProvider)new TANTrimMaterialTagsProvider(output, datapackProvider.getRegistryProvider()));
        generator.addProvider(true, (DataProvider)new TANPoiTypesTagsProvider(output, datapackProvider.getRegistryProvider()));
        generator.addProvider(true, (DataProvider)new TANEnchantmentTagsProvider(output, datapackProvider.getRegistryProvider()));
        generator.addProvider(true, (DataProvider)new TANEquipmentAssetProvider(output));
        generator.addProvider(true, (DataProvider)new TANModelProvider(output));
    }
}

