/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.neoforge.datagen.provider;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.neoforge.datagen.recipes.WaterPurifierRecipeBuilder;

public class TANRecipeProvider
extends RecipeProvider {
    public TANRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)TANItems.EMPTY_LEATHER_CANTEEN).define(Character.valueOf('#'), (ItemLike)Items.LEATHER).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_leather", this.has((ItemLike)Items.LEATHER)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)TANItems.EMPTY_COPPER_CANTEEN).define(Character.valueOf('#'), (ItemLike)Items.COPPER_INGOT).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_copper_ingot", this.has((ItemLike)Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)TANItems.EMPTY_IRON_CANTEEN).define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_iron_ingot", this.has((ItemLike)Items.IRON_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)TANItems.EMPTY_GOLD_CANTEEN).define(Character.valueOf('#'), (ItemLike)Items.GOLD_INGOT).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_gold_ingot", this.has((ItemLike)Items.GOLD_INGOT)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)TANItems.EMPTY_DIAMOND_CANTEEN).define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_diamond", this.has((ItemLike)Items.DIAMOND)).save(this.output);
        this.netheriteSmithing(this.output, TANItems.EMPTY_DIAMOND_CANTEEN, RecipeCategory.TOOLS, TANItems.EMPTY_NETHERITE_CANTEEN);
        this.netheriteSmithing(this.output, TANItems.DIAMOND_DIRTY_WATER_CANTEEN, RecipeCategory.TOOLS, TANItems.NETHERITE_DIRTY_WATER_CANTEEN);
        this.netheriteSmithing(this.output, TANItems.DIAMOND_WATER_CANTEEN, RecipeCategory.TOOLS, TANItems.NETHERITE_WATER_CANTEEN);
        this.netheriteSmithing(this.output, TANItems.DIAMOND_PURIFIED_WATER_CANTEEN, RecipeCategory.TOOLS, TANItems.NETHERITE_PURIFIED_WATER_CANTEEN);
        this.shapeless(RecipeCategory.FOOD, (ItemLike)TANItems.APPLE_JUICE).requires((ItemLike)TANItems.PURIFIED_WATER_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.APPLE).group("juice").unlockedBy("has_apple", this.has((ItemLike)Items.APPLE)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, (ItemLike)TANItems.CACTUS_JUICE).requires((ItemLike)TANItems.PURIFIED_WATER_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.CACTUS).group("juice").unlockedBy("has_cactus", this.has((ItemLike)Items.CACTUS)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, (ItemLike)TANItems.CHORUS_FRUIT_JUICE).requires((ItemLike)TANItems.PURIFIED_WATER_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.CHORUS_FRUIT).group("juice").unlockedBy("has_chorus_fruit", this.has((ItemLike)Items.CHORUS_FRUIT)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, (ItemLike)TANItems.GLOW_BERRY_JUICE).requires((ItemLike)TANItems.PURIFIED_WATER_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.GLOW_BERRIES).group("juice").unlockedBy("has_glow_berries", this.has((ItemLike)Items.GLOW_BERRIES)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, (ItemLike)TANItems.MELON_JUICE).requires((ItemLike)TANItems.PURIFIED_WATER_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.MELON_SLICE).group("juice").unlockedBy("has_melon_slice", this.has((ItemLike)Items.MELON_SLICE)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, (ItemLike)TANItems.PUMPKIN_JUICE).requires((ItemLike)TANItems.PURIFIED_WATER_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.PUMPKIN).group("juice").unlockedBy("has_pumpkin", this.has((ItemLike)Items.PUMPKIN)).save(this.output);
        this.shapeless(RecipeCategory.FOOD, (ItemLike)TANItems.SWEET_BERRY_JUICE).requires((ItemLike)TANItems.PURIFIED_WATER_BOTTLE).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.SWEET_BERRIES).group("juice").unlockedBy("has_sweet_berries", this.has((ItemLike)Items.SWEET_BERRIES)).save(this.output);
        this.shaped(RecipeCategory.FOOD, (ItemLike)TANItems.ICE_CREAM).define(Character.valueOf('#'), (ItemLike)Items.SNOWBALL).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('B'), (ItemLike)Items.BOWL).pattern(" # ").pattern("#S#").pattern(" B ").unlockedBy("has_snowball", this.has((ItemLike)Items.SNOWBALL)).save(this.output);
        this.shaped(RecipeCategory.FOOD, (ItemLike)TANItems.CHARC_0S).define(Character.valueOf('#'), (ItemLike)Items.CHARCOAL).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('B'), (ItemLike)Items.BOWL).pattern(" # ").pattern("#S#").pattern(" B ").unlockedBy("has_charcoal", this.has((ItemLike)Items.CHARCOAL)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)TANBlocks.THERMOREGULATOR).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('T'), (ItemLike)TANItems.THERMOMETER).pattern("SIS").pattern("ITI").pattern("SIS").unlockedBy("has_thermometer", this.has((ItemLike)TANItems.THERMOMETER)).save(this.output);
        this.shaped(RecipeCategory.REDSTONE, (ItemLike)TANBlocks.TEMPERATURE_GAUGE).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('T'), (ItemLike)TANItems.THERMOMETER).define(Character.valueOf('B'), (ItemLike)Items.BRICK_SLAB).pattern("GGG").pattern("QTQ").pattern("BBB").unlockedBy("has_thermometer", this.has((ItemLike)TANItems.THERMOMETER)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)TANBlocks.RAIN_COLLECTOR).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), (ItemLike)Items.STRING).pattern("WSW").pattern("W W").pattern("WWW").unlockedBy("has_string", this.has((ItemLike)Items.STRING)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)TANBlocks.WATER_PURIFIER).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GLASS).pattern("GCG").pattern("C C").pattern("WWW").unlockedBy("has_copper_ingot", this.has((ItemLike)Items.COPPER_INGOT)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.LEAF_BOOTS).define(Character.valueOf('X'), ItemTags.LEAVES).pattern("X X").pattern("X X").unlockedBy("has_leaves", this.has(ItemTags.LEAVES)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.LEAF_CHESTPLATE).define(Character.valueOf('X'), ItemTags.LEAVES).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_leaves", this.has(ItemTags.LEAVES)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.LEAF_HELMET).define(Character.valueOf('X'), ItemTags.LEAVES).pattern("XXX").pattern("X X").unlockedBy("has_leaves", this.has(ItemTags.LEAVES)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.LEAF_LEGGINGS).define(Character.valueOf('X'), ItemTags.LEAVES).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_leaves", this.has(ItemTags.LEAVES)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.WOOL_BOOTS).define(Character.valueOf('X'), ItemTags.WOOL).pattern("X X").pattern("X X").unlockedBy("has_wool", this.has(ItemTags.WOOL)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.WOOL_CHESTPLATE).define(Character.valueOf('X'), ItemTags.WOOL).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_wool", this.has(ItemTags.WOOL)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.WOOL_HELMET).define(Character.valueOf('X'), ItemTags.WOOL).pattern("XXX").pattern("X X").unlockedBy("has_wool", this.has(ItemTags.WOOL)).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)TANItems.WOOL_LEGGINGS).define(Character.valueOf('X'), ItemTags.WOOL).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_wool", this.has(ItemTags.WOOL)).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)TANItems.THERMOMETER).define(Character.valueOf('#'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('X'), (ItemLike)Items.REDSTONE).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_redstone", this.has((ItemLike)Items.REDSTONE)).save(this.output);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.DIRTY_WATER_BOTTLE), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER), 400);
        TANRecipeProvider.waterPurifier(this.output, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER), new ItemStack((ItemLike)TANItems.PURIFIED_WATER_BOTTLE), 200);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.LEATHER_DIRTY_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.LEATHER_WATER_CANTEEN), 400);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.COPPER_DIRTY_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.COPPER_WATER_CANTEEN), 400);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.IRON_DIRTY_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.IRON_WATER_CANTEEN), 400);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.GOLD_DIRTY_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.GOLD_WATER_CANTEEN), 400);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.DIAMOND_DIRTY_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.DIAMOND_WATER_CANTEEN), 400);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.NETHERITE_DIRTY_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.NETHERITE_WATER_CANTEEN), 400);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.LEATHER_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.LEATHER_PURIFIED_WATER_CANTEEN), 200);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.COPPER_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.COPPER_PURIFIED_WATER_CANTEEN), 200);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.IRON_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.IRON_PURIFIED_WATER_CANTEEN), 200);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.GOLD_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.GOLD_PURIFIED_WATER_CANTEEN), 200);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.DIAMOND_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.DIAMOND_PURIFIED_WATER_CANTEEN), 200);
        TANRecipeProvider.waterPurifier(this.output, new ItemStack((ItemLike)TANItems.NETHERITE_WATER_CANTEEN), new ItemStack((ItemLike)TANItems.NETHERITE_PURIFIED_WATER_CANTEEN), 200);
    }

    public static void waterPurifier(RecipeOutput output, ItemStack input, ItemStack result, int purifyTime) {
        WaterPurifierRecipeBuilder.waterPurifier(input, result, purifyTime).save(output, ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)TANRecipeProvider.getItemName((ItemLike)result.getItem())));
    }

    public void netheriteSmithing(RecipeOutput output, Item input, RecipeCategory category, Item result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)input), (Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_INGOT), (RecipeCategory)category, (Item)result).unlocks("has_netherite_ingot", this.has((ItemLike)Items.NETHERITE_INGOT)).save(output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)TANRecipeProvider.getItemName((ItemLike)result))) + "_smithing");
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput p_365442_, CompletableFuture<HolderLookup.Provider> p_362168_) {
            super(p_365442_, p_362168_);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new TANRecipeProvider(provider, output);
        }

        public String getName() {
            return "TAN Recipes";
        }
    }
}

