/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import glitchcore.event.TickEvent;
import glitchcore.event.client.RenderGuiEvent;
import glitchcore.util.GuiUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;

public class TemperatureOverlayRenderer {
    private static final Random RANDOM = new Random();
    public static final ResourceLocation OVERLAY = ResourceLocation.parse((String)"toughasnails:textures/gui/icons.png");
    private static final ResourceLocation HYPERTHERMIA_OUTLINE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"textures/misc/hyperthermia_outline.png");
    private static long updateCounter;
    private static long flashCounter;
    private static long arrowCounter;
    private static ArrowDirection arrowDirection;
    private static TemperatureLevel prevTemperatureLevel;

    public static void onBeginRenderFood(RenderGuiEvent.Pre event) {
        if (event.getType() != RenderGuiEvent.Type.FOOD) {
            return;
        }
        Gui gui = event.getGui();
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.options.hideGui && GuiUtils.shouldDrawSurvivalElements()) {
            TemperatureOverlayRenderer.renderTemperature(event.getGuiGraphics(), event.getDeltaTracker().getRealtimeDeltaTicks(), event.getScreenWidth(), event.getScreenHeight());
        }
    }

    public static void onBeginRenderFrostbite(RenderGuiEvent.Pre event) {
        if (event.getType() != RenderGuiEvent.Type.FROSTBITE) {
            return;
        }
        Gui gui = event.getGui();
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (TemperatureHelper.getTicksHyperthermic((Player)player) > 0) {
            gui.renderTextureOverlay(event.getGuiGraphics(), HYPERTHERMIA_OUTLINE_LOCATION, TemperatureHelper.getPercentHyperthermic((Player)player));
        }
    }

    public static void onClientTick(TickEvent.Client event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (event.getPhase() == TickEvent.Phase.END && !minecraft.isPaused()) {
            ++updateCounter;
        }
    }

    public static void renderTemperature(GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!ModConfig.temperature.enableTemperature) {
            return;
        }
        LocalPlayer player = minecraft.player;
        TemperatureLevel temperature = TemperatureHelper.getTemperatureForPlayer((Player)player);
        RANDOM.setSeed(updateCounter * 312871L);
        if (minecraft.gameMode.getPlayerMode().isSurvival()) {
            TemperatureOverlayRenderer.drawTemperature(guiGraphics, width, height, temperature);
        }
    }

    private static void drawTemperature(GuiGraphics gui, int width, int height, TemperatureLevel temperature) {
        int left = width / 2 - 8 + ModConfig.client.temperatureLeftOffset;
        int top = height - 52 + ModConfig.client.temperatureTopOffset;
        if (prevTemperatureLevel == null) {
            prevTemperatureLevel = temperature;
        }
        if (updateCounter > arrowCounter) {
            arrowDirection = null;
        }
        if (prevTemperatureLevel != temperature) {
            flashCounter = updateCounter + 3L;
            arrowCounter = updateCounter + 15L;
            if (temperature.compareTo(prevTemperatureLevel) > 0) {
                arrowDirection = ArrowDirection.UP;
            } else if (temperature.compareTo(prevTemperatureLevel) < 0) {
                arrowDirection = ArrowDirection.DOWN;
            }
        }
        prevTemperatureLevel = temperature;
        if ((temperature == TemperatureLevel.ICY || temperature == TemperatureLevel.HOT) && updateCounter % 1L == 0L) {
            top += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(3.0, 1.0));
            left += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(1.5, 1.0));
        }
        int iconIndex = temperature.ordinal() * 16;
        int v = 0;
        if (flashCounter > updateCounter) {
            v += 16;
        }
        gui.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, left, top, (float)iconIndex, (float)v, 16, 16, 256, 256);
        if (arrowDirection != null) {
            gui.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, left, top, (float)arrowDirection.getU(15 - (int)(arrowCounter - updateCounter)), (float)arrowDirection.getV(), 16, 16, 256, 256);
        }
    }

    private static enum ArrowDirection {
        UP(224),
        DOWN(240);

        private final int v;

        private ArrowDirection(int v) {
            this.v = v;
        }

        public int getU(int frame) {
            return frame * 16;
        }

        public int getV() {
            return this.v;
        }
    }
}

