/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import glitchcore.event.TickEvent;
import glitchcore.event.entity.LivingEntityUseItemEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.event.player.PlayerInteractEvent;
import glitchcore.network.CustomPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import toughasnails.api.damagesource.TANDamageTypes;
import toughasnails.api.item.TANItems;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;
import toughasnails.init.ModPackets;
import toughasnails.init.ModTags;
import toughasnails.network.DrinkInWorldPacket;
import toughasnails.network.UpdateThirstPacket;
import toughasnails.temperature.TemperatureData;

public class ThirstHandler {
    private static final int IN_WORLD_DRINK_COOLDOWN = 60;
    private static int inWorldDrinkTimer = 0;

    public static void onPlayerTick(Player player) {
        if (!ModConfig.thirst.enableThirst || player.level().isClientSide()) {
            return;
        }
        IThirst thirst = ThirstHelper.getThirst(player);
        Difficulty difficulty = player.level().getDifficulty();
        double exhaustionThreshold = ModConfig.thirst.thirstExhaustionThreshold;
        if ((double)thirst.getExhaustion() > exhaustionThreshold) {
            thirst.addExhaustion((float)(-exhaustionThreshold));
            if (thirst.getHydration() > 0.0f) {
                thirst.setHydration(Math.max(thirst.getHydration() - 1.0f, 0.0f));
            } else if (difficulty != Difficulty.PEACEFUL) {
                thirst.setThirst(Math.max(thirst.getThirst() - 1, 0));
            }
        }
        if (thirst.getThirst() <= 0) {
            thirst.addTicks(1);
            if (thirst.getTickTimer() >= 80) {
                if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.hurt(player.damageSources().source(TANDamageTypes.THIRST), 1.0f);
                }
                thirst.setTickTimer(0);
            }
        } else {
            thirst.setTickTimer(0);
        }
        if (difficulty == Difficulty.PEACEFUL && ((ServerLevel)player.level()).getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && thirst.isThirsty() && player.tickCount % 10 == 0) {
            thirst.setThirst(thirst.getThirst() + 1);
        }
    }

    public static void onChangeDimension(PlayerEvent.ChangeDimension event) {
        ITemperature temperature = TemperatureHelper.getTemperatureData(event.getPlayer());
        temperature.setLastLevel(TemperatureData.DEFAULT_LEVEL);
        temperature.setLastHyperthermiaTicks(0);
    }

    public static void syncThirst(ServerPlayer player) {
        IThirst thirst = ThirstHelper.getThirst((Player)player);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new UpdateThirstPacket(thirst.getThirst(), thirst.getHydration()), player);
        thirst.setLastThirst(thirst.getThirst());
        thirst.setLastHydrationZero(thirst.getHydration() == 0.0f);
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!ModConfig.thirst.enableThirst || !(event.getEntity() instanceof Player) || event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack drink = event.getItem();
        IThirst thirst = ThirstHelper.getThirst(player);
        if (drink.is(ModTags.Items.DRINKS)) {
            int drink_thirst = ModTags.Items.getThirstRestored(drink);
            float drink_hydration = 0.0f;
            float drink_poison_chance = 0.0f;
            if (drink.is(ModTags.Items.TEN_HYDRATION_DRINKS)) {
                drink_hydration = 0.1f;
            }
            if (drink.is(ModTags.Items.TWENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.2f;
            }
            if (drink.is(ModTags.Items.THIRTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.3f;
            }
            if (drink.is(ModTags.Items.FOURTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.4f;
            }
            if (drink.is(ModTags.Items.FIFTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.5f;
            }
            if (drink.is(ModTags.Items.SIXTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.6f;
            }
            if (drink.is(ModTags.Items.SEVENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.7f;
            }
            if (drink.is(ModTags.Items.EIGHTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.8f;
            }
            if (drink.is(ModTags.Items.NINETY_HYDRATION_DRINKS)) {
                drink_hydration = 0.9f;
            }
            if (drink.is(ModTags.Items.ONE_HUNDRED_HYDRATION_DRINKS)) {
                drink_hydration = 1.0f;
            }
            if (drink.is(ModTags.Items.TWENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.25f;
            }
            if (drink.is(ModTags.Items.FIFTY_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.5f;
            }
            if (drink.is(ModTags.Items.SEVENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.75f;
            }
            if (drink.is(ModTags.Items.ONE_HUNDRED_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 1.0f;
            }
            thirst.drink(drink_thirst, drink_hydration);
            if (player.level().random.nextFloat() < drink_poison_chance) {
                player.addEffect(new MobEffectInstance(TANEffects.THIRST, 600));
            }
        }
    }

    public static void onPlayerUseItem(PlayerInteractEvent.UseItem event) {
        Player player = event.getPlayer();
        Level level = player.level();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item != Items.GLASS_BOTTLE) {
            return;
        }
        BlockHitResult rayTraceResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = rayTraceResult.getBlockPos();
        if (!level.mayInteract((Entity)player, pos) || !level.getFluidState(pos).is(FluidTags.WATER)) {
            return;
        }
        level.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
        Holder biome = level.getBiome(pos);
        ItemStack filledStack = biome.is(ModTags.Biomes.DIRTY_WATER_BIOMES) ? new ItemStack((ItemLike)TANItems.DIRTY_WATER_BOTTLE) : (biome.is(ModTags.Biomes.PURIFIED_WATER_BIOMES) ? new ItemStack((ItemLike)TANItems.PURIFIED_WATER_BOTTLE) : PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER));
        player.awardStat(Stats.ITEM_USED.get((Object)item));
        ItemStack replacementStack = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)filledStack);
        event.setCancelResult((InteractionResult)InteractionResult.SUCCESS.heldItemTransformedTo(replacementStack));
        event.setCancelled(true);
    }

    public static void onUseBlock(PlayerInteractEvent.UseBlock event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    public static void onUseEmpty(PlayerInteractEvent.UseEmpty event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    public static void onClientTick(TickEvent.Client event) {
        if (inWorldDrinkTimer > 0) {
            --inWorldDrinkTimer;
        }
    }

    private static boolean canHandDrink() {
        return ModConfig.thirst.enableThirst && ModConfig.thirst.enableHandDrinking;
    }

    private static boolean canHandDrinkInWorld(Player player, InteractionHand hand) {
        return InteractionHand.MAIN_HAND == hand && player.getMainHandItem().isEmpty() && player.isCrouching() && ThirstHelper.getThirst(player).getThirst() < 20 && player.level().isClientSide() && inWorldDrinkTimer <= 0;
    }

    private static void tryDrinkWaterInWorld(Player player) {
        Level world = player.level();
        BlockHitResult rayTraceResult = Item.getPlayerPOVHitResult((Level)player.level(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = rayTraceResult.getBlockPos();
            if (ThirstHelper.canDrink(player, false) && world.mayInteract((Entity)player, pos) && world.getFluidState(pos).is(FluidTags.WATER)) {
                inWorldDrinkTimer = 60;
                ModPackets.HANDLER.sendToServer((CustomPacket)new DrinkInWorldPacket(pos));
                player.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.value(), 0.5f, 1.0f);
                player.swing(InteractionHand.MAIN_HAND);
            }
        }
    }
}

