/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import glitchcore.event.TickEvent;
import glitchcore.event.client.RenderGuiEvent;
import glitchcore.util.GuiUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;

public class ThirstOverlayRenderer {
    private static final Random RANDOM = new Random();
    public static final ResourceLocation OVERLAY = ResourceLocation.parse((String)"toughasnails:textures/gui/icons.png");
    private static int updateCounter;

    public static void onClientTick(TickEvent.Client event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (event.getPhase() == TickEvent.Phase.END && !minecraft.isPaused()) {
            ++updateCounter;
        }
    }

    public static void onBeginRenderAir(RenderGuiEvent.Pre event) {
        boolean isMounted;
        if (event.getType() != RenderGuiEvent.Type.AIR || !ModConfig.thirst.enableThirst) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Entity vehicle = minecraft.player.getVehicle();
        boolean bl = isMounted = vehicle != null && vehicle.showVehicleHealth();
        if (!isMounted && !minecraft.options.hideGui && GuiUtils.shouldDrawSurvivalElements()) {
            LocalPlayer player = minecraft.player;
            IThirst thirst = ThirstHelper.getThirst((Player)player);
            RANDOM.setSeed((long)updateCounter * 312871L);
            int rowTop = event.getRowTop();
            ThirstOverlayRenderer.drawThirst(event.getGuiGraphics(), event.getScreenWidth(), rowTop, thirst.getThirst(), thirst.getHydration());
            event.setRowTop(rowTop - 10);
        }
    }

    public static void drawThirst(GuiGraphics guiGraphics, int screenWidth, int rowTop, int thirstLevel, float thirstHydrationLevel) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        int left = screenWidth / 2 + 91 + ModConfig.client.thirstLeftOffset;
        int top = rowTop + ModConfig.client.thirstTopOffset;
        for (int i = 0; i < 10; ++i) {
            int dropletHalf = i * 2 + 1;
            int iconIndex = 0;
            int startX = left - i * 8 - 9;
            int startY = top;
            int backgroundU = 0;
            if (player.hasEffect(TANEffects.THIRST)) {
                iconIndex += 4;
                backgroundU += 117;
            }
            if (thirstHydrationLevel <= 0.0f && updateCounter % (thirstLevel * 3 + 1) == 0) {
                startY = top + (RANDOM.nextInt(3) - 1);
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, startX, startY, (float)backgroundU, 32.0f, 9, 9, 256, 256);
            if (thirstLevel > dropletHalf) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, startX, startY, (float)((iconIndex + 4) * 9), 32.0f, 9, 9, 256, 256);
                continue;
            }
            if (thirstLevel != dropletHalf) continue;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, OVERLAY, startX, startY, (float)((iconIndex + 5) * 9), 32.0f, 9, 9, 256, 256);
        }
    }
}

