/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block.entity;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.block.WaterPurifierBlock;
import toughasnails.container.WaterPurifierMenu;
import toughasnails.crafting.WaterPurifierRecipe;

public class WaterPurifierBlockEntity
extends class_2624
implements class_1278 {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FILTER = 1;
    protected static final int SLOT_RESULT = 2;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private class_2371<class_1799> items = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private int filterTimeRemaining;
    private int filterDuration;
    private int purifyProgress;
    private int purifyTotalTime;
    private final class_1863.class_7266<class_9696, ? extends class_1860<class_9696>> quickCheck;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return WaterPurifierBlockEntity.this.filterTimeRemaining;
                }
                case 1: {
                    return WaterPurifierBlockEntity.this.filterDuration;
                }
                case 2: {
                    return WaterPurifierBlockEntity.this.purifyProgress;
                }
                case 3: {
                    return WaterPurifierBlockEntity.this.purifyTotalTime;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    WaterPurifierBlockEntity.this.filterTimeRemaining = value;
                    break;
                }
                case 1: {
                    WaterPurifierBlockEntity.this.filterDuration = value;
                    break;
                }
                case 2: {
                    WaterPurifierBlockEntity.this.purifyProgress = value;
                    break;
                }
                case 3: {
                    WaterPurifierBlockEntity.this.purifyTotalTime = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public WaterPurifierBlockEntity(class_2338 pos, class_2680 state) {
        super(TANBlockEntityTypes.WATER_PURIFIER, pos, state);
        this.quickCheck = class_1863.method_42302(TANRecipeTypes.WATER_PURIFYING);
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)input, this.items);
        this.filterTimeRemaining = input.method_71439("FilterTimeRemaining").orElse(0);
        this.filterDuration = input.method_71439("FilterDuration").orElse(0);
        this.purifyProgress = input.method_71439("PurifyProgress").orElse(0);
        this.purifyTotalTime = input.method_71439("PurifyTotalTime").orElse(0);
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71465("FilterTimeRemaining", this.filterTimeRemaining);
        output.method_71465("FilterDuration", this.filterDuration);
        output.method_71465("PurifyProgress", this.purifyProgress);
        output.method_71465("PurifyTotalTime", this.purifyTotalTime);
        class_1262.method_5426((class_11372)output, this.items);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, WaterPurifierBlockEntity blockEntity) {
        class_1799 filterStack;
        boolean hasFilter;
        boolean previouslyFiltering = blockEntity.isFiltering();
        boolean changed = false;
        if (blockEntity.isFiltering()) {
            --blockEntity.filterTimeRemaining;
        }
        boolean bl = hasFilter = !(filterStack = (class_1799)blockEntity.items.get(1)).method_7960();
        if (blockEntity.isFiltering() || hasFilter && !((class_1799)blockEntity.items.get(0)).method_7960()) {
            class_8786 recipe = blockEntity.quickCheck.method_42303((class_9695)new class_9696((class_1799)blockEntity.items.get(0)), (class_3218)level).orElse(null);
            if (recipe != null) {
                if (!blockEntity.isFiltering() && blockEntity.canFilter((class_1860<class_9696>)recipe.comp_1933())) {
                    blockEntity.filterDuration = blockEntity.filterTimeRemaining = WaterPurifierBlockEntity.getFilterDuration(filterStack);
                    if (blockEntity.isFiltering()) {
                        changed = true;
                        if (hasFilter) {
                            class_1792 filter = filterStack.method_7909();
                            filterStack.method_7934(1);
                            if (filterStack.method_7960()) {
                                blockEntity.items.set(1, (Object)filter.method_7858());
                            }
                        }
                    }
                }
                if (blockEntity.isFiltering() && blockEntity.canFilter((class_1860<class_9696>)recipe.comp_1933())) {
                    ++blockEntity.purifyProgress;
                    if (blockEntity.purifyProgress == blockEntity.purifyTotalTime) {
                        blockEntity.purifyProgress = 0;
                        blockEntity.purifyTotalTime = blockEntity.getTotalPurifyTime();
                        blockEntity.filter((class_1860<class_9696>)recipe.comp_1933());
                        changed = true;
                    }
                } else {
                    blockEntity.purifyProgress = 0;
                }
            } else if (!blockEntity.isFiltering() && blockEntity.purifyProgress > 0) {
                blockEntity.purifyProgress = class_3532.method_15340((int)(blockEntity.purifyProgress - 2), (int)0, (int)blockEntity.purifyTotalTime);
            }
        }
        if (previouslyFiltering != blockEntity.isFiltering()) {
            changed = true;
            state = (class_2680)state.method_11657((class_2769)WaterPurifierBlock.PURIFYING, (Comparable)Boolean.valueOf(blockEntity.isFiltering()));
            level.method_8652(pos, state, 3);
        }
        if (changed) {
            WaterPurifierBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    protected class_1703 method_5465(int id, class_1661 player) {
        return new WaterPurifierMenu(id, player, (class_1263)this, this.dataAccess);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.toughasnails.water_purifier");
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    public int[] method_5494(class_2350 side) {
        switch (side) {
            case field_11033: {
                return SLOTS_FOR_DOWN;
            }
            case field_11036: {
                return SLOTS_FOR_UP;
            }
        }
        return SLOTS_FOR_SIDES;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        return WaterPurifierBlockEntity.isFilter(stack);
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return direction != class_2350.field_11033 || index != 1;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.items) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.items, (int)index, (int)count);
    }

    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.items, (int)index);
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 currentStack = (class_1799)this.items.get(index);
        boolean sameItem = !stack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)currentStack);
        this.items.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (index == 0 && !sameItem) {
            this.purifyTotalTime = this.getTotalPurifyTime();
            this.purifyProgress = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.items.clear();
    }

    public boolean isFiltering() {
        return this.filterTimeRemaining > 0;
    }

    protected boolean canFilter(@Nullable class_1860<class_9696> recipe) {
        if (!((class_1799)this.items.get(0)).method_7960() && recipe != null) {
            class_1799 input = (class_1799)this.items.get(0);
            class_1799 recipeResult = recipe.method_8116((class_9695)new class_9696(input), (class_7225.class_7874)this.field_11863.method_30349());
            if (recipeResult.method_7960()) {
                return false;
            }
            class_1799 currentResult = (class_1799)this.items.get(2);
            if (currentResult.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)currentResult, (class_1799)recipeResult)) {
                return false;
            }
            if (currentResult.method_7947() + recipeResult.method_7947() <= this.method_5444() && currentResult.method_7947() + recipeResult.method_7947() <= currentResult.method_7914()) {
                return true;
            }
            return currentResult.method_7947() + recipeResult.method_7947() <= recipeResult.method_7914();
        }
        return false;
    }

    protected int getTotalPurifyTime() {
        class_9696 singlerecipeinput = new class_9696((class_1799)this.items.get(0));
        return this.quickCheck.method_42303((class_9695)singlerecipeinput, (class_3218)this.field_11863).map(p_379263_ -> ((WaterPurifierRecipe)p_379263_.comp_1933()).getPurifyTime()).orElse(200);
    }

    private void filter(@Nullable class_1860<class_9696> recipe) {
        if (recipe != null && this.canFilter(recipe)) {
            class_1799 input = (class_1799)this.items.get(0);
            class_1799 recipeResult = recipe.method_8116((class_9695)new class_9696(input), (class_7225.class_7874)this.field_11863.method_30349());
            class_1799 currentResult = (class_1799)this.items.get(2);
            if (currentResult.method_7960()) {
                this.items.set(2, (Object)recipeResult.method_7972());
            } else if (currentResult.method_7909() == recipeResult.method_7909()) {
                currentResult.method_7933(recipeResult.method_7947());
            }
            input.method_7934(1);
        }
    }

    public static boolean isFilter(class_1799 stack) {
        return WaterPurifierBlockEntity.getFilterDuration(stack) > 0;
    }

    public static int getFilterDuration(class_1799 filter) {
        if (filter == null || filter.method_7960()) {
            return 0;
        }
        return (Integer)WaterPurifierBlockEntity.getFilterDurations().getOrDefault((Object)filter.method_7909(), (Object)0);
    }

    private static ImmutableMap<class_1792, Integer> getFilterDurations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<class_1792, Integer>)builder, class_1802.field_8602, 100);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<class_1792, Integer>)builder, class_1802.field_8407, 200);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<class_1792, Integer>)builder, class_1802.field_8110, 400);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<class_1792, Integer>)builder, (class_6862<class_1792>)class_3489.field_15532, 800);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<class_1792, Integer>)builder, class_1802.field_8665, 1600);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<class_1792, Integer>)builder, class_1802.field_8434, 3200);
        WaterPurifierBlockEntity.add((ImmutableMap.Builder<class_1792, Integer>)builder, class_1802.field_8207, 6400);
        return builder.build();
    }

    private static void add(ImmutableMap.Builder<class_1792, Integer> builder, class_6862<class_1792> tagKey, int i) {
        for (class_6880 holder : class_7923.field_41178.method_40286(tagKey)) {
            builder.put((Object)((class_1792)holder.comp_349()), (Object)i);
        }
    }

    private static void add(ImmutableMap.Builder<class_1792, Integer> builder, class_1792 item, int i) {
        builder.put((Object)item, (Object)i);
    }
}

