/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.core;

import glitchcore.event.EventManager;
import glitchcore.util.Environment;
import glitchcore.util.RegistryHelper;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toughasnails.client.handler.KeyHandler;
import toughasnails.client.handler.LevelRenderHandler;
import toughasnails.client.handler.TooltipHandler;
import toughasnails.init.ModApi;
import toughasnails.init.ModBlockEntities;
import toughasnails.init.ModBlocks;
import toughasnails.init.ModClient;
import toughasnails.init.ModCompatibility;
import toughasnails.init.ModConfig;
import toughasnails.init.ModContainerTypes;
import toughasnails.init.ModCrafting;
import toughasnails.init.ModCreativeTab;
import toughasnails.init.ModItems;
import toughasnails.init.ModPackets;
import toughasnails.init.ModParticles;
import toughasnails.init.ModPotions;
import toughasnails.init.ModTags;
import toughasnails.init.ModVillages;
import toughasnails.temperature.TemperatureHandler;
import toughasnails.temperature.TemperatureOverlayRenderer;
import toughasnails.thirst.ThirstHandler;
import toughasnails.thirst.ThirstOverlayRenderer;

public class ToughAsNails {
    public static final String MOD_ID = "toughasnails";
    public static final Logger LOGGER = LogManager.getLogger((String)"toughasnails");

    public static void init() {
        ModConfig.init();
        ModTags.init();
        ToughAsNails.addRegistrars();
        ToughAsNails.addHandlers();
        ModPackets.init();
        ModApi.init();
        ModCompatibility.init();
    }

    public static void setupClient() {
        ModClient.setupRenderTypes();
    }

    public static void onServerAboutToStart(MinecraftServer server) {
        ModVillages.addBuildings((class_5455)server.method_30611());
    }

    private static void addRegistrars() {
        RegistryHelper regHelper = RegistryHelper.create();
        regHelper.addRegistrar(class_7924.field_41254, ModBlocks::registerBlocks);
        regHelper.addRegistrar(class_7924.field_41197, ModItems::registerItems);
        regHelper.addRegistrar(class_7924.field_41207, ModContainerTypes::registerContainers);
        regHelper.addRegistrar(class_7924.field_41255, ModBlockEntities::registerBlockEntities);
        regHelper.addRegistrar(class_7924.field_41216, ModCrafting::registerRecipeSerializers);
        regHelper.addRegistrar(class_7924.field_41217, ModCrafting::registerRecipeTypes);
        regHelper.addRegistrar(class_7924.field_54928, ModCrafting::registerRecipeBookCategories);
        regHelper.addRegistrar(class_7924.field_41208, ModPotions::registerEffects);
        regHelper.addRegistrar(class_7924.field_41215, ModPotions::registerPotions);
        regHelper.addRegistrar(class_7924.field_44688, ModCreativeTab::registerCreativeTabs);
        regHelper.addRegistrar(class_7924.field_41210, ModParticles::registerParticles);
        regHelper.addRegistrar(class_7924.field_41212, ModVillages::registerPointsOfInterest);
        regHelper.addRegistrar(class_7924.field_41234, ModVillages::registerProfessions);
    }

    private static void addHandlers() {
        EventManager.addListener(TemperatureHandler::onChangeDimension);
        EventManager.addListener(TemperatureHandler::onItemUseFinish);
        EventManager.addListener(ThirstHandler::onChangeDimension);
        EventManager.addListener(ThirstHandler::onItemUseFinish);
        EventManager.addListener(ThirstHandler::onPlayerUseItem);
        EventManager.addListener(ThirstHandler::onUseBlock);
        EventManager.addListener(ModVillages::addVillagerTrades);
        EventManager.addListener(ModVillages::addWanderingVillagerTrades);
        if (Environment.isClient()) {
            ToughAsNails.addClientHandlers();
        }
    }

    private static void addClientHandlers() {
        EventManager.addListener(TemperatureOverlayRenderer::onClientTick);
        EventManager.addListener(TemperatureOverlayRenderer::onBeginRenderFood);
        EventManager.addListener(TemperatureOverlayRenderer::onBeginRenderFrostbite);
        EventManager.addListener(LevelRenderHandler::onLevelRender);
        EventManager.addListener(ThirstOverlayRenderer::onClientTick);
        EventManager.addListener(ThirstOverlayRenderer::onBeginRenderAir);
        EventManager.addListener(ThirstHandler::onUseEmpty);
        EventManager.addListener(ThirstHandler::onClientTick);
        EventManager.addListener(ModClient::registerBlockColors);
        EventManager.addListener(ModClient::registerParticleSprites);
        EventManager.addListener(TooltipHandler::onTooltip);
        EventManager.addListener(TooltipHandler::onRenderTooltip);
        EventManager.addListener(KeyHandler::onKeyPress);
    }
}

