/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;

public class AreaFill {
    public static void fill(class_1937 level, class_2338 pos, PositionChecker checker) {
        AreaFill.fill(level, pos, checker, ModConfig.temperature.nearHeatCoolProximity);
    }

    public static void fill(class_1937 level, class_2338 pos, PositionChecker checker, int maxDepth) {
        HashSet checked = Sets.newHashSet();
        LinkedList<FillPos> queue = new LinkedList<FillPos>();
        queue.add(new FillPos(pos, 1, class_2350.field_11033));
        while (!queue.isEmpty()) {
            FillPos posToCheck = (FillPos)queue.poll();
            if (checked.contains(posToCheck)) continue;
            if (AreaFill.checkPassable(checker, level, posToCheck)) {
                FillPos westPos = posToCheck;
                while (westPos.depth() < maxDepth && AreaFill.checkPassable(checker, level, westPos)) {
                    checked.add(westPos);
                    AreaFill.expand(queue, checked, checker, level, westPos);
                    westPos = westPos.west();
                }
                checked.add(westPos);
                if (!AreaFill.checkPassable(checker, level, westPos)) {
                    AreaFill.checkSolid(checked, checker, level, westPos);
                }
                if (posToCheck.depth() >= maxDepth) continue;
                FillPos eastPos = posToCheck.east();
                while (eastPos.depth() < maxDepth && AreaFill.checkPassable(checker, level, eastPos)) {
                    checked.add(eastPos);
                    AreaFill.expand(queue, checked, checker, level, eastPos);
                    eastPos = eastPos.east();
                }
                checked.add(eastPos);
                if (AreaFill.checkPassable(checker, level, eastPos)) continue;
                AreaFill.checkSolid(checked, checker, level, eastPos);
                continue;
            }
            AreaFill.checkSolid(checked, checker, level, posToCheck);
        }
    }

    private static void expand(Queue<FillPos> queue, Set<FillPos> checked, PositionChecker checker, class_1937 level, FillPos pos) {
        FillPos north = pos.north();
        FillPos south = pos.south();
        FillPos down = pos.below();
        FillPos up = pos.above();
        if (AreaFill.checkPassable(checker, level, north)) {
            queue.add(north);
        } else {
            AreaFill.checkSolid(checked, checker, level, north);
        }
        if (AreaFill.checkPassable(checker, level, south)) {
            queue.add(south);
        } else {
            AreaFill.checkSolid(checked, checker, level, south);
        }
        if (AreaFill.checkPassable(checker, level, down)) {
            queue.add(down);
        } else {
            AreaFill.checkSolid(checked, checker, level, down);
        }
        if (AreaFill.checkPassable(checker, level, up)) {
            queue.add(up);
        } else {
            AreaFill.checkSolid(checked, checker, level, up);
        }
    }

    private static void checkSolid(Set<FillPos> checked, PositionChecker checker, class_1937 level, FillPos pos) {
        checked.add(pos);
        checker.onSolid(level, pos);
    }

    private static boolean checkPassable(PositionChecker checker, class_1937 level, FillPos pos) {
        boolean passable = checker.isPassable(level, pos);
        if (passable) {
            checker.onPassable(level, pos);
        }
        return passable;
    }

    public static interface PositionChecker {
        public void onSolid(class_1937 var1, FillPos var2);

        default public void onPassable(class_1937 level, FillPos pos) {
        }

        default public boolean isPassable(class_1937 level, FillPos pos) {
            class_2680 state = level.method_8320(pos.pos());
            return state.method_26215() || state.method_26164(ModTags.Blocks.PASSABLE_BLOCKS) || !this.isFlowBlocking(level, pos, state) && !TemperatureHelper.isHeatingBlock(state) && !TemperatureHelper.isCoolingBlock(state);
        }

        default public boolean isConfined(class_1937 level, class_2338 pos) {
            return pos.method_10264() < level.method_8598(class_2902.class_2903.field_13203, pos).method_10074().method_10264();
        }

        default public boolean isFlowBlocking(class_1937 level, FillPos pos, class_2680 state) {
            return state.method_26206((class_1922)level, pos.pos(), pos.source()) || state.method_26206((class_1922)level, pos.pos(), pos.source().method_10153());
        }
    }

    public record FillPos(class_2338 pos, int depth, class_2350 source) {
        public FillPos north() {
            return new FillPos(this.pos().method_10095(), this.depth() + 1, class_2350.field_11035);
        }

        public FillPos south() {
            return new FillPos(this.pos().method_10072(), this.depth() + 1, class_2350.field_11043);
        }

        public FillPos east() {
            return new FillPos(this.pos().method_10078(), this.depth() + 1, class_2350.field_11039);
        }

        public FillPos west() {
            return new FillPos(this.pos().method_10067(), this.depth() + 1, class_2350.field_11034);
        }

        public FillPos above() {
            return new FillPos(this.pos().method_10084(), this.depth() + 1, class_2350.field_11033);
        }

        public FillPos below() {
            return new FillPos(this.pos().method_10074(), this.depth() + 1, class_2350.field_11036);
        }
    }
}

