/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3486;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8055;
import net.minecraft.class_9274;
import toughasnails.api.enchantment.TANEnchantments;
import toughasnails.api.player.ITANPlayer;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.IPositionalTemperatureModifier;
import toughasnails.api.temperature.IProximityBlockModifier;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;
import toughasnails.temperature.AreaFill;

public class TemperatureHelperImpl
implements TemperatureHelper.Impl.ITemperatureHelper {
    protected static List<IPositionalTemperatureModifier> positionalModifiers = Lists.newArrayList((Object[])new IPositionalTemperatureModifier[]{TemperatureHelperImpl::altitudeModifier, TemperatureHelperImpl::rainModifier});
    protected static List<IProximityBlockModifier> proximityModifiers = new ArrayList<IProximityBlockModifier>();
    protected static List<IPlayerTemperatureModifier> playerModifiers = Lists.newArrayList((Object[])new IPlayerTemperatureModifier[]{TemperatureHelperImpl::thermoregulatorModifier, TemperatureHelperImpl::immersionModifier});

    @Override
    public TemperatureLevel getTemperatureAtPos(class_1937 level, class_2338 pos) {
        TemperatureLevel temperature = TemperatureHelperImpl.getBiomeTemperatureLevel(level, pos);
        temperature = TemperatureHelperImpl.nightModifier(level, pos, temperature);
        for (IPositionalTemperatureModifier modifier : positionalModifiers) {
            temperature = modifier.modify(level, pos, temperature);
        }
        return TemperatureHelperImpl.proximityModifier(level, pos, temperature);
    }

    public static TemperatureLevel getTemperatureAtPosWithoutProximity(class_1937 level, class_2338 pos) {
        TemperatureLevel temperature = TemperatureHelperImpl.getBiomeTemperatureLevel(level, pos);
        temperature = TemperatureHelperImpl.nightModifier(level, pos, temperature);
        for (IPositionalTemperatureModifier modifier : positionalModifiers) {
            temperature = modifier.modify(level, pos, temperature);
        }
        return temperature;
    }

    @Override
    public ITemperature getPlayerTemperature(class_1657 player) {
        return ((ITANPlayer)player).getTemperatureData();
    }

    @Override
    public boolean isTemperatureEnabled() {
        return ModConfig.temperature.enableTemperature;
    }

    @Override
    public void setTicksHyperthermic(class_1657 player, int ticks) {
        this.getPlayerTemperature(player).setHyperthermiaTicks(ticks);
    }

    @Override
    public float getPercentHyperthermic(class_1657 player) {
        int i = this.getTicksRequiredForHyperthermia();
        return (float)Math.min(this.getTicksHyperthermic(player), i) / (float)i;
    }

    @Override
    public boolean isFullyHyperthermic(class_1657 player) {
        return this.getTicksHyperthermic(player) >= this.getTicksRequiredForHyperthermia();
    }

    @Override
    public int getTicksRequiredForHyperthermia() {
        return 140;
    }

    @Override
    public int getTicksHyperthermic(class_1657 player) {
        return this.getPlayerTemperature(player).getHyperthermiaTicks();
    }

    @Override
    public boolean isHeating(class_2680 state) {
        return state.method_26164(ModTags.Blocks.HEATING_BLOCKS) && (state.method_28498((class_2769)class_2741.field_12548) ? (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false : (state.method_28498((class_2769)class_2741.field_12484) ? (Boolean)state.method_11654((class_2769)class_2741.field_12484) != false : (state.method_28498((class_2769)class_2741.field_12515) ? (Boolean)state.method_11654((class_2769)class_2741.field_12515) != false : (state.method_28498((class_2769)class_2746.method_11825((String)"active")) ? (Boolean)state.method_11654((class_2769)class_2746.method_11825((String)"active")) != false : !state.method_28498((class_2769)class_2746.method_11825((String)"on")) || (Boolean)state.method_11654((class_2769)class_2746.method_11825((String)"on")) != false))));
    }

    @Override
    public boolean isCooling(class_2680 state) {
        return state.method_26164(ModTags.Blocks.COOLING_BLOCKS) && (state.method_28498((class_2769)class_2741.field_12548) ? (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false : (state.method_28498((class_2769)class_2741.field_12484) ? (Boolean)state.method_11654((class_2769)class_2741.field_12484) != false : (state.method_28498((class_2769)class_2741.field_12515) ? (Boolean)state.method_11654((class_2769)class_2741.field_12515) != false : (state.method_28498((class_2769)class_2746.method_11825((String)"active")) ? (Boolean)state.method_11654((class_2769)class_2746.method_11825((String)"active")) != false : !state.method_28498((class_2769)class_2746.method_11825((String)"on")) || (Boolean)state.method_11654((class_2769)class_2746.method_11825((String)"on")) != false))));
    }

    @Override
    public void registerPlayerTemperatureModifier(IPlayerTemperatureModifier modifier) {
        playerModifiers.add(modifier);
    }

    @Override
    public void registerPositionalTemperatureModifier(IPositionalTemperatureModifier modifier) {
        positionalModifiers.add(modifier);
    }

    @Override
    public void registerProximityBlockModifier(IProximityBlockModifier modifier) {
        proximityModifiers.add(modifier);
    }

    private static TemperatureLevel getBiomeTemperatureLevel(class_1937 level, class_2338 pos) {
        class_6880 biome = level.method_23753(pos);
        float biomeTemperature = ((class_1959)biome.comp_349()).method_8712();
        if (!level.method_8597().comp_645() || pos.method_10264() > ModConfig.temperature.environmentalModifierAltitude || pos.method_10264() >= level.method_8598(class_2902.class_2903.field_13197, pos).method_10074().method_10264()) {
            if (biome.method_40220(ModTags.Biomes.ICY_BIOMES)) {
                return TemperatureLevel.ICY;
            }
            if (biome.method_40220(ModTags.Biomes.COLD_BIOMES)) {
                return TemperatureLevel.COLD;
            }
            if (biome.method_40220(ModTags.Biomes.NEUTRAL_BIOMES)) {
                return TemperatureLevel.NEUTRAL;
            }
            if (biome.method_40220(ModTags.Biomes.WARM_BIOMES)) {
                return TemperatureLevel.WARM;
            }
            if (biome.method_40220(ModTags.Biomes.HOT_BIOMES)) {
                return TemperatureLevel.HOT;
            }
            if (biomeTemperature < 0.15f) {
                return TemperatureLevel.ICY;
            }
            if (biomeTemperature >= 0.15f && biomeTemperature < 0.45f) {
                return TemperatureLevel.COLD;
            }
            if (biomeTemperature >= 0.45f && biomeTemperature < 0.85f) {
                return TemperatureLevel.NEUTRAL;
            }
            if (biomeTemperature >= 0.85f && biomeTemperature < 1.0f) {
                return TemperatureLevel.WARM;
            }
            if (biomeTemperature >= 1.0f) {
                return TemperatureLevel.HOT;
            }
        }
        return TemperatureLevel.NEUTRAL;
    }

    private static TemperatureLevel altitudeModifier(class_1937 level, class_2338 pos, TemperatureLevel current) {
        if (!level.method_8597().comp_645()) {
            return current;
        }
        if (pos.method_10264() > ModConfig.temperature.temperatureDropAltitude) {
            current = current.decrement(1);
        } else if (pos.method_10264() < ModConfig.temperature.temperatureRiseAltitude) {
            current = current.increment(1);
        }
        return current;
    }

    private static TemperatureLevel rainModifier(class_1937 level, class_2338 pos, TemperatureLevel current) {
        class_6880 biome = level.method_23753(pos);
        if (TemperatureHelperImpl.isExposedToRain(level, pos)) {
            current = TemperatureHelperImpl.coldEnoughToSnow(level, (class_6880<class_1959>)biome, pos) ? current.increment(ModConfig.temperature.snowTemperatureChange) : current.increment(ModConfig.temperature.wetTemperatureChange);
        }
        return current;
    }

    private static TemperatureLevel nightModifier(class_1937 level, class_2338 pos, TemperatureLevel current) {
        boolean isNight;
        float time = level.method_30274(1.0f);
        boolean bl = isNight = time >= 0.25f && time <= 0.75f;
        if (level.method_8597().comp_645() && isNight && (pos.method_10264() > ModConfig.temperature.environmentalModifierAltitude || pos.method_10264() >= level.method_8598(class_2902.class_2903.field_13197, pos).method_10074().method_10264())) {
            if (current == TemperatureLevel.HOT) {
                current = current.increment(ModConfig.temperature.nightHotTemperatureChange);
            } else if (current != TemperatureLevel.NEUTRAL) {
                current = current.increment(ModConfig.temperature.nightTemperatureChange);
            }
        }
        return current;
    }

    private static TemperatureLevel proximityModifier(class_1937 level, class_2338 pos, TemperatureLevel current) {
        HashSet heating = Sets.newHashSet();
        HashSet cooling = Sets.newHashSet();
        if (!level.method_22347(pos)) {
            pos = pos.method_10084();
        }
        AreaFill.fill(level, pos, (checkerLevel, checkedPos) -> TemperatureHelperImpl.addHeatingOrCooling(heating, cooling, checkerLevel, checkedPos.pos()));
        if (heating.size() > cooling.size()) {
            current = current.increment(1);
        } else if (cooling.size() > heating.size()) {
            current = current.decrement(1);
        }
        return current;
    }

    private static void addHeatingOrCooling(Set<class_2338> heating, Set<class_2338> cooling, class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (TemperatureHelper.isHeatingBlock(state)) {
            heating.add(pos);
        } else if (TemperatureHelper.isCoolingBlock(state)) {
            cooling.add(pos);
        } else {
            for (IProximityBlockModifier modifier : proximityModifiers) {
                IProximityBlockModifier.Type sourceType = modifier.getProximityType(level, pos, state);
                if (sourceType == IProximityBlockModifier.Type.HEATING) {
                    heating.add(pos);
                    continue;
                }
                if (sourceType != IProximityBlockModifier.Type.COOLING) continue;
                cooling.add(pos);
            }
        }
    }

    private static TemperatureLevel thermoregulatorModifier(class_1657 player, TemperatureLevel current) {
        return TemperatureHelperImpl.modifyTemperatureByThermoregulators(player.method_73183(), TemperatureHelper.getTemperatureData(player).getNearbyThermoregulators(), player.method_24515(), current);
    }

    private static TemperatureLevel immersionModifier(class_1657 player, TemperatureLevel current) {
        class_1937 level = player.method_73183();
        class_2338 pos = player.method_24515();
        ITemperature temperature = TemperatureHelper.getTemperatureData(player);
        if (player.method_5809()) {
            current = current.increment(ModConfig.temperature.onFireTemperatureChange);
        }
        if (player.field_27857) {
            current = current.increment(ModConfig.temperature.powderSnowTemperatureChange);
        }
        if (TemperatureHelperImpl.isExposedToRain(level, pos)) {
            temperature.setDryTicks(0);
        } else if (!(player.method_5668() instanceof class_1690) && (player.method_5799() || level.method_8316(pos).method_15767(class_3486.field_15517))) {
            temperature.setDryTicks(0);
            current = current.increment(ModConfig.temperature.wetTemperatureChange);
        } else if (temperature.getDryTicks() < ModConfig.temperature.wetTicks) {
            current.increment(ModConfig.temperature.wetTemperatureChange);
        }
        return current;
    }

    protected static TemperatureLevel handheldModifier(class_1657 player, TemperatureLevel current) {
        AtomicInteger coolingItems = new AtomicInteger();
        AtomicInteger heatingItems = new AtomicInteger();
        for (class_1304 slot : class_9274.field_49219) {
            class_1799 stack = player.method_6118(slot);
            if (stack.method_31573(ModTags.Items.COOLING_HELD_ITEMS)) {
                coolingItems.getAndIncrement();
            }
            if (!stack.method_31573(ModTags.Items.HEATING_HELD_ITEMS)) continue;
            heatingItems.getAndIncrement();
        }
        return current.increment(heatingItems.get() - coolingItems.get());
    }

    protected static TemperatureLevel armorModifier(class_1657 player, TemperatureLevel current) {
        AtomicInteger coolingPieces = new AtomicInteger();
        AtomicInteger heatingPieces = new AtomicInteger();
        for (class_1304 slot : class_9274.field_49224) {
            class_1799 stack = player.method_6118(slot);
            if (stack.method_31573(ModTags.Items.COOLING_ARMOR) || stack.method_31573(ModTags.Items.HEATING_ARMOR)) {
                if (stack.method_31573(ModTags.Items.COOLING_ARMOR)) {
                    coolingPieces.getAndIncrement();
                }
                if (!stack.method_31573(ModTags.Items.HEATING_ARMOR)) continue;
                heatingPieces.getAndIncrement();
                continue;
            }
            class_8055.method_48440((class_7225.class_7874)player.method_73183().method_30349(), (class_1799)stack).ifPresent(material -> {
                if (material.method_40220(ModTags.Trims.COOLING_TRIMS)) {
                    coolingPieces.getAndIncrement();
                }
                if (material.method_40220(ModTags.Trims.HEATING_TRIMS)) {
                    heatingPieces.getAndIncrement();
                }
            });
        }
        TemperatureLevel armorAdjTemp = current.increment(heatingPieces.get() / 2 - coolingPieces.get() / 2);
        current = armorAdjTemp == TemperatureLevel.HOT && current != TemperatureLevel.HOT ? armorAdjTemp.decrement(1) : (armorAdjTemp == TemperatureLevel.ICY && current != TemperatureLevel.ICY ? armorAdjTemp.increment(1) : armorAdjTemp);
        class_2378 enchantmentRegistry = player.method_56673().method_30530(class_7924.field_41265);
        if (class_1890.method_8203((class_6880)enchantmentRegistry.method_46747(TANEnchantments.THERMAL_TUNING), (class_1309)player) > 0) {
            current = TemperatureLevel.NEUTRAL;
        }
        return current;
    }

    protected static TemperatureLevel internalModifier(class_1657 player, TemperatureLevel current) {
        TemperatureLevel newTemperature = current;
        if (player.method_6059(TANEffects.INTERNAL_WARMTH)) {
            newTemperature = newTemperature.increment(1);
        }
        if (player.method_6059(TANEffects.INTERNAL_CHILL)) {
            newTemperature = newTemperature.decrement(1);
        }
        current = newTemperature == TemperatureLevel.HOT && current != TemperatureLevel.HOT ? newTemperature.decrement(1) : (newTemperature == TemperatureLevel.ICY && current != TemperatureLevel.ICY ? newTemperature.increment(1) : newTemperature);
        return current;
    }

    private static boolean isExposedToRain(class_1937 level, class_2338 pos) {
        return level.method_8419() && pos.method_10264() >= level.method_8598(class_2902.class_2903.field_13197, pos).method_10074().method_10264();
    }

    private static boolean coldEnoughToSnow(class_1937 level, class_6880<class_1959> biome, class_2338 pos) {
        return ((class_1959)biome.comp_349()).method_33599(pos, level.method_8615());
    }

    public static TemperatureLevel modifyTemperatureByThermoregulators(class_1937 level, Set<class_2338> thermoregulators, class_2338 checkPos, TemperatureLevel current) {
        int coolingCount = 0;
        int heatingCount = 0;
        int neutralCount = 0;
        for (class_2338 pos : thermoregulators) {
            ThermoregulatorBlockEntity blockEntity = (ThermoregulatorBlockEntity)level.method_8321(pos);
            if (blockEntity == null) continue;
            switch (blockEntity.getEffectAtPos(checkPos)) {
                case COOLING: {
                    ++coolingCount;
                    break;
                }
                case HEATING: {
                    ++heatingCount;
                    break;
                }
                case NEUTRALIZING: {
                    ++neutralCount;
                }
            }
        }
        if (coolingCount == 0 && heatingCount == 0 && neutralCount > 0) {
            return TemperatureLevel.NEUTRAL;
        }
        if (coolingCount > heatingCount) {
            return current.decrement(2);
        }
        if (heatingCount > coolingCount) {
            return current.increment(2);
        }
        return current;
    }
}

