/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import glitchcore.event.client.LevelRenderEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.temperature.AreaFill;

public class LevelRenderHandler {
    public static boolean enableDebug = false;
    private static final Set<ConnectedBlock> connectedBlocks = new HashSet<ConnectedBlock>();

    public static void onLevelRender(LevelRenderEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!enableDebug || player == null) {
            return;
        }
        Vec3 cameraPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        LevelRenderHandler.getConnectedBlocks((Player)player).forEach(block -> block.render(poseStack, vertexConsumer));
        poseStack.popPose();
    }

    private static Set<ConnectedBlock> getConnectedBlocks(Player player) {
        Level level = player.level();
        connectedBlocks.clear();
        LevelRenderHandler.populateConnectedBlocks(player);
        return connectedBlocks;
    }

    private static void populateConnectedBlocks(Player player) {
        BlockPos playerPos;
        Level level = player.level();
        if (!level.isEmptyBlock(playerPos = player.blockPosition())) {
            playerPos = playerPos.above();
        }
        final HashSet<BlockPos> passablePositions = new HashSet<BlockPos>();
        final HashSet<BlockPos> heatingPositions = new HashSet<BlockPos>();
        final HashSet<BlockPos> coolingPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> thermoregulatorPositions = new HashSet<BlockPos>();
        final HashSet<BlockPos> blockingPositions = new HashSet<BlockPos>();
        AreaFill.fill(level, playerPos, new AreaFill.PositionChecker(){

            @Override
            public void onSolid(Level level, AreaFill.FillPos pos) {
                BlockState state = level.getBlockState(pos.pos());
                if (TemperatureHelper.isHeatingBlock(state)) {
                    heatingPositions.add(pos.pos());
                } else if (TemperatureHelper.isCoolingBlock(state)) {
                    coolingPositions.add(pos.pos());
                } else {
                    blockingPositions.add(pos.pos());
                }
            }

            @Override
            public void onPassable(Level level, AreaFill.FillPos pos) {
                passablePositions.add(pos.pos());
            }
        });
        for (BlockPos pos : TemperatureHelper.getTemperatureData(player).getNearbyThermoregulators()) {
            ThermoregulatorBlockEntity blockEntity = (ThermoregulatorBlockEntity)level.getBlockEntity(pos);
            if (blockEntity == null) continue;
            thermoregulatorPositions.addAll((Collection<BlockPos>)blockEntity.getFilledBlocks());
        }
        LevelRenderHandler.connectBlocks(passablePositions, 170, 170, 170, 255);
        LevelRenderHandler.connectBlocks(heatingPositions, 255, 170, 0, 255);
        LevelRenderHandler.connectBlocks(coolingPositions, 85, 255, 255, 255);
        LevelRenderHandler.connectBlocks(thermoregulatorPositions, 255, 85, 255, 255);
        LevelRenderHandler.connectBlocks(blockingPositions, 255, 85, 85, 255);
    }

    private static void connectBlocks(Set<BlockPos> positions, int r, int g, int b, int a) {
        for (BlockPos pos : positions) {
            HashSet<Direction> connectedFaces = new HashSet<Direction>();
            for (Direction dir : Direction.values()) {
                if (!positions.contains(pos.relative(dir))) continue;
                connectedFaces.add(dir);
            }
            if (connectedFaces.containsAll(Arrays.stream(Direction.values()).toList())) continue;
            connectedBlocks.add(new ConnectedBlock(pos, connectedFaces, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f));
        }
    }

    private static class ConnectedBlock {
        private final BlockPos pos;
        private final Set<Direction> connectedFaces;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final float minX;
        private final float minY;
        private final float minZ;
        private final float maxX;
        private final float maxY;
        private final float maxZ;

        private ConnectedBlock(BlockPos pos, Set<Direction> connectedFaces, float r, float g, float b, float a) {
            this.pos = pos;
            this.connectedFaces = connectedFaces;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.minX = (float)pos.getX() + 1.0E-4f;
            this.minY = (float)pos.getY() + 1.0E-4f;
            this.minZ = (float)pos.getZ() + 1.0E-4f;
            this.maxX = (float)pos.getX() + 1.0f - 1.0E-4f;
            this.maxY = (float)pos.getY() + 1.0f - 1.0E-4f;
            this.maxZ = (float)pos.getZ() + 1.0f - 1.0E-4f;
        }

        public void render(PoseStack poseStack, VertexConsumer vertexConsumer) {
            Matrix4f poseMatrix = poseStack.last().pose();
            PoseStack.Pose lastPose = poseStack.last();
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.minZ, this.maxX, this.minY, this.minZ, Direction.NORTH, Direction.DOWN);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.minZ, this.minX, this.maxY, this.minZ, Direction.NORTH, Direction.WEST);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.minY, this.minZ, this.maxX, this.maxY, this.minZ, Direction.NORTH, Direction.EAST);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.maxY, this.minZ, this.minX, this.maxY, this.minZ, Direction.NORTH, Direction.UP);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.maxY, this.maxZ, this.minX, this.minY, this.maxZ, Direction.SOUTH, Direction.WEST);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.maxZ, this.maxX, this.minY, this.maxZ, Direction.SOUTH, Direction.DOWN);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.maxY, this.maxZ, this.maxX, this.maxY, this.maxZ, Direction.SOUTH, Direction.UP);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.minY, this.maxZ, this.maxX, this.maxY, this.maxZ, Direction.SOUTH, Direction.EAST);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.minY, this.minZ, this.minX, this.minY, this.maxZ, Direction.WEST, Direction.DOWN);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.minX, this.maxY, this.minZ, this.minX, this.maxY, this.maxZ, Direction.WEST, Direction.UP);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.minY, this.maxZ, this.maxX, this.minY, this.minZ, Direction.EAST, Direction.DOWN);
            this.drawLine(vertexConsumer, poseMatrix, lastPose, this.maxX, this.maxY, this.minZ, this.maxX, this.maxY, this.maxZ, Direction.EAST, Direction.UP);
        }

        public Set<Direction> getConnectedFaces() {
            return this.connectedFaces;
        }

        private void drawLine(VertexConsumer vertexConsumer, Matrix4f poseMatrix, PoseStack.Pose lastPose, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, Direction ... relevantFaces) {
            if (Arrays.stream(relevantFaces).anyMatch(this.connectedFaces::contains)) {
                return;
            }
            float normalX = Math.signum(fromX - toX);
            float normalY = Math.signum(fromY - toY);
            float normalZ = Math.signum(fromZ - toZ);
            vertexConsumer.addVertex(poseMatrix, fromX, fromY, fromZ).setColor(this.r, this.g, this.b, this.a).setNormal(lastPose, normalX, normalY, normalZ);
            vertexConsumer.addVertex(poseMatrix, toX, toY, toZ).setColor(this.r, this.g, this.b, this.a).setNormal(lastPose, normalX, normalY, normalZ);
        }
    }
}

