/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.container;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.container.TANContainerTypes;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.container.ThermoregulatorCoolingFuelSlot;
import toughasnails.container.ThermoregulatorHeatingFuelSlot;

public class ThermoregulatorContainer
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    private final Level level;

    public ThermoregulatorContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public ThermoregulatorContainer(int id, Inventory playerInventory, Container container, ContainerData data) {
        super(TANContainerTypes.THERMOREGULATOR, id);
        this.container = container;
        this.data = data;
        this.level = playerInventory.player.level();
        this.addSlot(new ThermoregulatorCoolingFuelSlot(container, 0, 44, 42));
        this.addSlot(new ThermoregulatorHeatingFuelSlot(container, 1, 116, 42));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlot(new Slot((Container)playerInventory, slot, 8 + slot * 18, 142));
        }
        this.addDataSlots(data);
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack prevItem = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            prevItem = slotItem.copy();
            if (index != 1 && index != 0 ? (ThermoregulatorBlockEntity.isCoolingFuel(slotItem) ? !this.moveItemStackTo(slotItem, 0, 1, false) : (ThermoregulatorBlockEntity.isHeatingFuel(slotItem) ? !this.moveItemStackTo(slotItem, 1, 2, false) : (index >= 2 && index < 30 ? !this.moveItemStackTo(slotItem, 30, 38, false) : index >= 30 && index < 38 && !this.moveItemStackTo(slotItem, 2, 30, false)))) : !this.moveItemStackTo(slotItem, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == prevItem.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItem);
        }
        return prevItem;
    }

    public int getCoolingFuelProgress() {
        return this.data.get(0) * 13 / 1600;
    }

    public int getHeatingFuelProgress() {
        return this.data.get(1) * 13 / 1600;
    }

    public boolean isCooling() {
        return this.data.get(0) > 0;
    }

    public boolean isHeating() {
        return this.data.get(1) > 0;
    }
}

