/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import toughasnails.api.item.TANItems;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.item.EmptyCanteenItem;

public class FilledCanteenItem
extends EmptyCanteenItem {
    private static final int CONSUME_TICKS = 32;

    public FilledCanteenItem(int tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        block3: {
            block2: {
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (stack.getItem() != this.getPurifiedWaterCanteen() && !stack.getEnchantments().isEmpty()) break block3;
            }
            return;
        }
        ItemStack newStack = new ItemStack((ItemLike)this.getPurifiedWaterCanteen());
        newStack.setDamageValue(stack.getDamageValue());
        stack.getEnchantments().entrySet().forEach(e -> newStack.enchant((Holder)e.getKey(), e.getIntValue()));
        player.getInventory().setItem(slot.getIndex(), newStack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int useItemRemainingTicks) {
        if (this.shouldEmitSounds(useItemRemainingTicks)) {
            entity.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.value(), 0.5f, Mth.randomBetween((RandomSource)level.getRandom(), (float)0.9f, (float)1.0f));
        }
    }

    private boolean shouldEmitSounds(int useItemRemainingTicks) {
        int elapsedTicks = 32 - useItemRemainingTicks;
        int delay = 7;
        boolean flag = elapsedTicks > delay;
        return flag && useItemRemainingTicks % 4 == 0;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResult result = this.fillCanteen(level, player, stack);
        if (result.consumesAction()) {
            return result;
        }
        if (ThirstHelper.canDrink(player, this.canAlwaysDrink())) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.FAIL;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (player == null) {
            return stack;
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!worldIn.isClientSide() && !player.getAbilities().instabuild) {
            ItemStack emptyStack = new ItemStack((ItemLike)this.getEmptyCanteen());
            stack.getEnchantments().entrySet().forEach(e -> emptyStack.enchant((Holder)e.getKey(), e.getIntValue()));
            AtomicBoolean broken = new AtomicBoolean(false);
            stack.hurtAndBreak(1, (ServerLevel)worldIn, (ServerPlayer)player, item -> broken.set(true));
            if (broken.get()) {
                return emptyStack;
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public boolean canAlwaysDrink() {
        return false;
    }

    public Item getEmptyCanteen() {
        switch (this.tier) {
            default: {
                return TANItems.EMPTY_LEATHER_CANTEEN;
            }
            case 1: {
                return TANItems.EMPTY_COPPER_CANTEEN;
            }
            case 2: {
                return TANItems.EMPTY_IRON_CANTEEN;
            }
            case 3: {
                return TANItems.EMPTY_GOLD_CANTEEN;
            }
            case 4: {
                return TANItems.EMPTY_DIAMOND_CANTEEN;
            }
            case 5: 
        }
        return TANItems.EMPTY_NETHERITE_CANTEEN;
    }
}

