/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.mixin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toughasnails.crafting.WaterPurifierRecipe;
import toughasnails.init.ModRecipePropertySets;

@Mixin(value={RecipeManager.class})
public class MixinRecipeManager {
    @Shadow
    private static Map<ResourceKey<RecipePropertySet>, RecipeManager.IngredientExtractor> RECIPE_PROPERTY_SETS;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void onInit(CallbackInfo ci) {
        RECIPE_PROPERTY_SETS = ImmutableMap.builder().putAll(RECIPE_PROPERTY_SETS).put(ModRecipePropertySets.WATER_PURIFYING, recipe -> {
            Optional<Object> optional;
            if (recipe instanceof WaterPurifierRecipe) {
                WaterPurifierRecipe waterPurifierRecipe = (WaterPurifierRecipe)recipe;
                optional = Optional.of(Ingredient.of((ItemLike)waterPurifierRecipe.input().getItem()));
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).build();
    }
}

