/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.handler;

import glitchcore.event.client.ItemTooltipEvent;
import glitchcore.event.client.RenderTooltipEvent;
import glitchcore.util.Environment;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;
import toughasnails.thirst.ThirstOverlayRenderer;

public class TooltipHandler {
    public static void onTooltip(ItemTooltipEvent event) {
        if (!ModConfig.temperature.enableTemperature) {
            return;
        }
        if (!Environment.isClient()) {
            throw new IllegalStateException("ItemTooltipEvent unexpectedly called on the server");
        }
        if (Minecraft.getInstance().getConnection() == null) {
            return;
        }
        ItemStack stack = event.getStack();
        Block block = Block.byItem((Item)stack.getItem());
        BlockState state = block.defaultBlockState();
        RegistryAccess.Frozen registryAccess = Minecraft.getInstance().getConnection().registryAccess();
        Optional trimMaterial = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)stack);
        if (state.is(ModTags.Blocks.HEATING_BLOCKS) || stack.is(ModTags.Items.HEATING_ARMOR) || trimMaterial.isPresent() && ((Holder)trimMaterial.get()).is(ModTags.Trims.HEATING_TRIMS)) {
            event.getTooltip().add(Component.literal((String)"\ud83d\udd25 ").append((Component)Component.translatable((String)"desc.toughasnails.heating")).withStyle(ChatFormatting.GOLD));
        }
        if (state.is(ModTags.Blocks.COOLING_BLOCKS) || stack.is(ModTags.Items.COOLING_ARMOR) || trimMaterial.isPresent() && ((Holder)trimMaterial.get()).is(ModTags.Trims.COOLING_TRIMS)) {
            event.getTooltip().add(Component.literal((String)"\u2744 ").append((Component)Component.translatable((String)"desc.toughasnails.cooling")).withStyle(ChatFormatting.AQUA));
        }
        if (stack.is(ModTags.Items.HEATING_HELD_ITEMS)) {
            event.getTooltip().add(Component.literal((String)"\ud83d\udd25 ").append((Component)Component.translatable((String)"desc.toughasnails.heating_held")).withStyle(ChatFormatting.GOLD));
        }
        if (stack.is(ModTags.Items.COOLING_HELD_ITEMS)) {
            event.getTooltip().add(Component.literal((String)"\u2744 ").append((Component)Component.translatable((String)"desc.toughasnails.cooling_held")).withStyle(ChatFormatting.AQUA));
        }
        if (stack.is(ModTags.Items.HEATING_CONSUMED_ITEMS)) {
            event.getTooltip().add(Component.literal((String)"\ud83d\udd25 ").append((Component)Component.translatable((String)"desc.toughasnails.heating_consumed")).withStyle(ChatFormatting.GOLD));
        }
        if (stack.is(ModTags.Items.COOLING_CONSUMED_ITEMS)) {
            event.getTooltip().add(Component.literal((String)"\u2744 ").append((Component)Component.translatable((String)"desc.toughasnails.cooling_consumed")).withStyle(ChatFormatting.AQUA));
        }
        if (trimMaterial.isPresent() && ((Holder)trimMaterial.get()).is(ModTags.Trims.HEATING_TRIMS)) {
            event.getTooltip().add(Component.literal((String)"\ud83d\udd25 ").append((Component)Component.translatable((String)"desc.toughasnails.heating_trim")).withStyle(ChatFormatting.GOLD));
        }
        if (trimMaterial.isPresent() && ((Holder)trimMaterial.get()).is(ModTags.Trims.COOLING_TRIMS)) {
            event.getTooltip().add(Component.literal((String)"\u2744 ").append((Component)Component.translatable((String)"desc.toughasnails.cooling_trim")).withStyle(ChatFormatting.AQUA));
        }
    }

    public static void onRenderTooltip(RenderTooltipEvent event) {
        ItemStack stack = event.getStack();
        if (!ModConfig.thirst.enableThirst) {
            return;
        }
        if (stack.is(ModTags.Items.DRINKS)) {
            event.getComponents().add(new ThirstClientTooltipComponent(ModTags.Items.getThirstRestored(stack)));
        }
    }

    private static class ThirstClientTooltipComponent
    implements ClientTooltipComponent {
        private final int amount;

        private ThirstClientTooltipComponent(int amount) {
            this.amount = amount;
        }

        public int getHeight(Font font) {
            return 9;
        }

        public int getWidth(Font font) {
            return this.amount / 2 * 8;
        }

        public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics gui) {
            gui.pose().pushMatrix();
            for (int i = 0; i < Mth.ceil((float)((float)this.amount / 2.0f)); ++i) {
                int dropletHalf = i * 2 + 1;
                int startX = x + i * 8;
                int startY = y;
                if (this.amount > dropletHalf) {
                    gui.blit(RenderPipelines.GUI_TEXTURED, ThirstOverlayRenderer.OVERLAY, startX, startY, 0.0f, 41.0f, 8, 8, 256, 256);
                    continue;
                }
                if (this.amount != dropletHalf) continue;
                gui.blit(RenderPipelines.GUI_TEXTURED, ThirstOverlayRenderer.OVERLAY, startX, startY, 8.0f, 41.0f, 8, 8, 256, 256);
            }
            gui.pose().popMatrix();
        }
    }
}

