/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.block.Block;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.init.ModArmorMaterials;
import toughasnails.item.DirtyWaterBottleItem;
import toughasnails.item.EmptyCanteenItem;
import toughasnails.item.FilledCanteenItem;
import toughasnails.item.JuiceItem;
import toughasnails.item.PurifiedWaterBottleItem;
import toughasnails.item.StackableBowlFoodItem;

public class ModItems {
    public static void registerItems(BiConsumer<ResourceLocation, Item> func) {
        TANItems.THERMOREGULATOR = ModItems.registerBlock(func, TANBlocks.THERMOREGULATOR);
        TANItems.TEMPERATURE_GAUGE = ModItems.registerBlock(func, TANBlocks.TEMPERATURE_GAUGE);
        TANItems.RAIN_COLLECTOR = ModItems.registerBlock(func, TANBlocks.RAIN_COLLECTOR);
        TANItems.WATER_PURIFIER = ModItems.registerBlock(func, TANBlocks.WATER_PURIFIER);
        TANItems.THERMOMETER = ModItems.registerItem(func, "thermometer", Item::new, new Item.Properties().stacksTo(1));
        TANItems.LEAF_HELMET = ModItems.registerItem(func, "leaf_helmet", new Item.Properties().humanoidArmor(ModArmorMaterials.LEAF, ArmorType.HELMET).stacksTo(1));
        TANItems.LEAF_CHESTPLATE = ModItems.registerItem(func, "leaf_chestplate", new Item.Properties().humanoidArmor(ModArmorMaterials.LEAF, ArmorType.CHESTPLATE).stacksTo(1));
        TANItems.LEAF_LEGGINGS = ModItems.registerItem(func, "leaf_leggings", new Item.Properties().humanoidArmor(ModArmorMaterials.LEAF, ArmorType.LEGGINGS).stacksTo(1));
        TANItems.LEAF_BOOTS = ModItems.registerItem(func, "leaf_boots", new Item.Properties().humanoidArmor(ModArmorMaterials.LEAF, ArmorType.BOOTS).stacksTo(1));
        TANItems.WOOL_HELMET = ModItems.registerItem(func, "wool_helmet", new Item.Properties().component(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0xFFFFFF)).humanoidArmor(ModArmorMaterials.WOOL, ArmorType.HELMET).stacksTo(1));
        TANItems.WOOL_CHESTPLATE = ModItems.registerItem(func, "wool_chestplate", new Item.Properties().component(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0xFFFFFF)).humanoidArmor(ModArmorMaterials.WOOL, ArmorType.CHESTPLATE).stacksTo(1));
        TANItems.WOOL_LEGGINGS = ModItems.registerItem(func, "wool_leggings", new Item.Properties().component(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0xFFFFFF)).humanoidArmor(ModArmorMaterials.WOOL, ArmorType.LEGGINGS).stacksTo(1));
        TANItems.WOOL_BOOTS = ModItems.registerItem(func, "wool_boots", new Item.Properties().component(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0xFFFFFF)).humanoidArmor(ModArmorMaterials.WOOL, ArmorType.BOOTS).stacksTo(1));
        TANItems.ICE_CREAM = ModItems.registerItem(func, "ice_cream", StackableBowlFoodItem::new, new Item.Properties().stacksTo(16).component(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_FOOD).usingConvertsTo(Items.BOWL).food(new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().build()));
        TANItems.CHARC_0S = ModItems.registerItem(func, "charc_os", StackableBowlFoodItem::new, new Item.Properties().stacksTo(16).component(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_FOOD).usingConvertsTo(Items.BOWL).food(new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().build()));
        TANItems.EMPTY_LEATHER_CANTEEN = ModItems.registerItem(func, "empty_leather_canteen", (Item.Properties p) -> new EmptyCanteenItem(0, (Item.Properties)p), new Item.Properties().enchantable(1).stacksTo(1));
        TANItems.LEATHER_DIRTY_WATER_CANTEEN = ModItems.registerItem(func, "leather_dirty_water_canteen", (Item.Properties p) -> new FilledCanteenItem(0, (Item.Properties)p), new Item.Properties().durability(5));
        TANItems.LEATHER_WATER_CANTEEN = ModItems.registerItem(func, "leather_water_canteen", (Item.Properties p) -> new FilledCanteenItem(0, (Item.Properties)p), new Item.Properties().durability(5));
        TANItems.LEATHER_PURIFIED_WATER_CANTEEN = ModItems.registerItem(func, "leather_purified_water_canteen", (Item.Properties p) -> new FilledCanteenItem(0, (Item.Properties)p), new Item.Properties().durability(5));
        TANItems.EMPTY_COPPER_CANTEEN = ModItems.registerItem(func, "empty_copper_canteen", (Item.Properties p) -> new EmptyCanteenItem(1, (Item.Properties)p), new Item.Properties().enchantable(1).stacksTo(1));
        TANItems.COPPER_DIRTY_WATER_CANTEEN = ModItems.registerItem(func, "copper_dirty_water_canteen", (Item.Properties p) -> new FilledCanteenItem(1, (Item.Properties)p), new Item.Properties().durability(6));
        TANItems.COPPER_WATER_CANTEEN = ModItems.registerItem(func, "copper_water_canteen", (Item.Properties p) -> new FilledCanteenItem(1, (Item.Properties)p), new Item.Properties().durability(6));
        TANItems.COPPER_PURIFIED_WATER_CANTEEN = ModItems.registerItem(func, "copper_purified_water_canteen", (Item.Properties p) -> new FilledCanteenItem(1, (Item.Properties)p), new Item.Properties().durability(6));
        TANItems.EMPTY_IRON_CANTEEN = ModItems.registerItem(func, "empty_iron_canteen", (Item.Properties p) -> new EmptyCanteenItem(2, (Item.Properties)p), new Item.Properties().enchantable(1).stacksTo(1));
        TANItems.IRON_DIRTY_WATER_CANTEEN = ModItems.registerItem(func, "iron_dirty_water_canteen", (Item.Properties p) -> new FilledCanteenItem(2, (Item.Properties)p), new Item.Properties().durability(7));
        TANItems.IRON_WATER_CANTEEN = ModItems.registerItem(func, "iron_water_canteen", (Item.Properties p) -> new FilledCanteenItem(2, (Item.Properties)p), new Item.Properties().durability(7));
        TANItems.IRON_PURIFIED_WATER_CANTEEN = ModItems.registerItem(func, "iron_purified_water_canteen", (Item.Properties p) -> new FilledCanteenItem(2, (Item.Properties)p), new Item.Properties().durability(7));
        TANItems.EMPTY_GOLD_CANTEEN = ModItems.registerItem(func, "empty_gold_canteen", (Item.Properties p) -> new EmptyCanteenItem(3, (Item.Properties)p), new Item.Properties().enchantable(1).stacksTo(1));
        TANItems.GOLD_DIRTY_WATER_CANTEEN = ModItems.registerItem(func, "gold_dirty_water_canteen", (Item.Properties p) -> new FilledCanteenItem(3, (Item.Properties)p), new Item.Properties().durability(10));
        TANItems.GOLD_WATER_CANTEEN = ModItems.registerItem(func, "gold_water_canteen", (Item.Properties p) -> new FilledCanteenItem(3, (Item.Properties)p), new Item.Properties().durability(10));
        TANItems.GOLD_PURIFIED_WATER_CANTEEN = ModItems.registerItem(func, "gold_purified_water_canteen", (Item.Properties p) -> new FilledCanteenItem(3, (Item.Properties)p), new Item.Properties().durability(10));
        TANItems.EMPTY_DIAMOND_CANTEEN = ModItems.registerItem(func, "empty_diamond_canteen", (Item.Properties p) -> new EmptyCanteenItem(4, (Item.Properties)p), new Item.Properties().enchantable(1).stacksTo(1));
        TANItems.DIAMOND_DIRTY_WATER_CANTEEN = ModItems.registerItem(func, "diamond_dirty_water_canteen", (Item.Properties p) -> new FilledCanteenItem(4, (Item.Properties)p), new Item.Properties().durability(15));
        TANItems.DIAMOND_WATER_CANTEEN = ModItems.registerItem(func, "diamond_water_canteen", (Item.Properties p) -> new FilledCanteenItem(4, (Item.Properties)p), new Item.Properties().durability(15));
        TANItems.DIAMOND_PURIFIED_WATER_CANTEEN = ModItems.registerItem(func, "diamond_purified_water_canteen", (Item.Properties p) -> new FilledCanteenItem(4, (Item.Properties)p), new Item.Properties().durability(15));
        TANItems.EMPTY_NETHERITE_CANTEEN = ModItems.registerItem(func, "empty_netherite_canteen", (Item.Properties p) -> new EmptyCanteenItem(5, (Item.Properties)p), new Item.Properties().enchantable(1).stacksTo(1));
        TANItems.NETHERITE_DIRTY_WATER_CANTEEN = ModItems.registerItem(func, "netherite_dirty_water_canteen", (Item.Properties p) -> new FilledCanteenItem(5, (Item.Properties)p), new Item.Properties().durability(25));
        TANItems.NETHERITE_WATER_CANTEEN = ModItems.registerItem(func, "netherite_water_canteen", (Item.Properties p) -> new FilledCanteenItem(5, (Item.Properties)p), new Item.Properties().durability(25));
        TANItems.NETHERITE_PURIFIED_WATER_CANTEEN = ModItems.registerItem(func, "netherite_purified_water_canteen", (Item.Properties p) -> new FilledCanteenItem(5, (Item.Properties)p), new Item.Properties().durability(25));
        TANItems.DIRTY_WATER_BOTTLE = ModItems.registerItem(func, "dirty_water_bottle", DirtyWaterBottleItem::new, new Item.Properties().stacksTo(1));
        TANItems.PURIFIED_WATER_BOTTLE = ModItems.registerItem(func, "purified_water_bottle", PurifiedWaterBottleItem::new, new Item.Properties().stacksTo(1));
        TANItems.APPLE_JUICE = ModItems.registerItem(func, "apple_juice", JuiceItem::new, new Item.Properties().stacksTo(16));
        TANItems.CACTUS_JUICE = ModItems.registerItem(func, "cactus_juice", JuiceItem::new, new Item.Properties().stacksTo(16));
        TANItems.CHORUS_FRUIT_JUICE = ModItems.registerItem(func, "chorus_fruit_juice", JuiceItem::new, new Item.Properties().stacksTo(16));
        TANItems.GLOW_BERRY_JUICE = ModItems.registerItem(func, "glow_berry_juice", JuiceItem::new, new Item.Properties().stacksTo(16));
        TANItems.MELON_JUICE = ModItems.registerItem(func, "melon_juice", JuiceItem::new, new Item.Properties().stacksTo(16));
        TANItems.PUMPKIN_JUICE = ModItems.registerItem(func, "pumpkin_juice", JuiceItem::new, new Item.Properties().stacksTo(16));
        TANItems.SWEET_BERRY_JUICE = ModItems.registerItem(func, "sweet_berry_juice", JuiceItem::new, new Item.Properties().stacksTo(16));
        TANItems.TAN_ICON = ModItems.registerItem(func, "tan_icon", Item::new, new Item.Properties());
    }

    public static Item registerBlock(BiConsumer<ResourceLocation, Item> func, Block block) {
        return ModItems.registerBlock(func, block, BlockItem::new);
    }

    public static Item registerBlock(BiConsumer<ResourceLocation, Item> func, Block block, BiFunction<Block, Item.Properties, Item> factory) {
        return ModItems.registerBlock(func, block, factory, new Item.Properties());
    }

    public static Item registerBlock(BiConsumer<ResourceLocation, Item> func, Block block, BiFunction<Block, Item.Properties, Item> factory, Item.Properties properties) {
        return ModItems.registerItem(func, ModItems.blockIdToItemId((ResourceKey<Block>)block.builtInRegistryHolder().key()), (Item.Properties p_370785_) -> (Item)factory.apply(block, (Item.Properties)p_370785_), properties.useBlockDescriptionPrefix());
    }

    private static Item registerItem(BiConsumer<ResourceLocation, Item> func, ResourceKey<Item> key, Function<Item.Properties, Item> factory, Item.Properties properties) {
        Item item = factory.apply(properties.setId(key));
        func.accept(key.location(), item);
        return item;
    }

    private static Item registerItem(BiConsumer<ResourceLocation, Item> func, String name, Function<Item.Properties, Item> factory, Item.Properties properties) {
        return ModItems.registerItem(func, ModItems.itemId(name), factory, properties);
    }

    private static Item registerItem(BiConsumer<ResourceLocation, Item> func, String name, Item.Properties properties) {
        return ModItems.registerItem(func, ModItems.itemId(name), Item::new, properties);
    }

    private static ResourceKey<Item> blockIdToItemId(ResourceKey<Block> key) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key.location());
    }

    private static ResourceKey<Item> itemId(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)name));
    }
}

