/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.enchantment.TANEnchantments;
import toughasnails.api.item.TANItems;
import toughasnails.block.RainCollectorBlock;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;

public class EmptyCanteenItem
extends Item {
    int tier;

    public EmptyCanteenItem(int tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        return this.fillCanteen(level, player, player.getItemInHand(hand));
    }

    protected InteractionResult fillCanteen(Level level, Player player, ItemStack stack) {
        BlockPos pos;
        BlockHitResult rayTraceResult = EmptyCanteenItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK && level.mayInteract((Entity)player, pos = rayTraceResult.getBlockPos())) {
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() instanceof RainCollectorBlock) {
                int waterLevel = (Integer)state.getValue((Property)RainCollectorBlock.LEVEL);
                if (waterLevel > 0 && !level.isClientSide()) {
                    level.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ((RainCollectorBlock)TANBlocks.RAIN_COLLECTOR).setWaterLevel(level, pos, state, waterLevel - 1);
                    return InteractionResult.SUCCESS.heldItemTransformedTo(this.replaceCanteen(stack, player, new ItemStack((ItemLike)this.getPurifiedWaterCanteen())));
                }
            } else if (state.getBlock() == Blocks.WATER_CAULDRON) {
                int waterLevel = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                if (waterLevel > 0 && !level.isClientSide()) {
                    level.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
                    return InteractionResult.SUCCESS.heldItemTransformedTo(this.replaceCanteen(stack, player, new ItemStack((ItemLike)this.getWaterCanteen())));
                }
            } else if (level.getFluidState(pos).is(FluidTags.WATER)) {
                level.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (ModConfig.thirst.removeSourceBlocks) {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                }
                Holder biome = player.level().getBiome(player.blockPosition());
                Registry enchantmentRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                Item canteenItem = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantmentRegistry.getOrThrow(TANEnchantments.WATER_CLEANSING), (ItemStack)stack) > 0 || biome.is(ModTags.Biomes.PURIFIED_WATER_BIOMES) ? this.getPurifiedWaterCanteen() : (biome.is(ModTags.Biomes.DIRTY_WATER_BIOMES) ? this.getDirtyWaterCanteen() : this.getWaterCanteen());
                return InteractionResult.SUCCESS.heldItemTransformedTo(this.replaceCanteen(stack, player, new ItemStack((ItemLike)canteenItem)));
            }
        }
        return InteractionResult.PASS;
    }

    protected ItemStack replaceCanteen(ItemStack oldStack, Player player, ItemStack newStack) {
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        EnchantmentHelper.setEnchantments((ItemStack)newStack, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)oldStack));
        return ItemUtils.createFilledResult((ItemStack)oldStack, (Player)player, (ItemStack)newStack);
    }

    public Item getDirtyWaterCanteen() {
        switch (this.tier) {
            default: {
                return TANItems.LEATHER_DIRTY_WATER_CANTEEN;
            }
            case 1: {
                return TANItems.COPPER_DIRTY_WATER_CANTEEN;
            }
            case 2: {
                return TANItems.IRON_DIRTY_WATER_CANTEEN;
            }
            case 3: {
                return TANItems.GOLD_DIRTY_WATER_CANTEEN;
            }
            case 4: {
                return TANItems.DIAMOND_DIRTY_WATER_CANTEEN;
            }
            case 5: 
        }
        return TANItems.NETHERITE_DIRTY_WATER_CANTEEN;
    }

    public Item getWaterCanteen() {
        switch (this.tier) {
            default: {
                return TANItems.LEATHER_WATER_CANTEEN;
            }
            case 1: {
                return TANItems.COPPER_WATER_CANTEEN;
            }
            case 2: {
                return TANItems.IRON_WATER_CANTEEN;
            }
            case 3: {
                return TANItems.GOLD_WATER_CANTEEN;
            }
            case 4: {
                return TANItems.DIAMOND_WATER_CANTEEN;
            }
            case 5: 
        }
        return TANItems.NETHERITE_WATER_CANTEEN;
    }

    public Item getPurifiedWaterCanteen() {
        switch (this.tier) {
            default: {
                return TANItems.LEATHER_PURIFIED_WATER_CANTEEN;
            }
            case 1: {
                return TANItems.COPPER_PURIFIED_WATER_CANTEEN;
            }
            case 2: {
                return TANItems.IRON_PURIFIED_WATER_CANTEEN;
            }
            case 3: {
                return TANItems.GOLD_PURIFIED_WATER_CANTEEN;
            }
            case 4: {
                return TANItems.DIAMOND_PURIFIED_WATER_CANTEEN;
            }
            case 5: 
        }
        return TANItems.NETHERITE_PURIFIED_WATER_CANTEEN;
    }
}

