/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.neoforge.datagen.model;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.EquipmentAsset;
import toughasnails.init.ModEquipmentAssets;

public class TANEquipmentAssetProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public TANEquipmentAssetProvider(PackOutput output) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "equipment");
    }

    private static void bootstrap(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> output) {
        output.accept(ModEquipmentAssets.LEAF, EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"leaf"), true).addHumanoidLayers(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"leaf_overlay"), true).build());
        output.accept(ModEquipmentAssets.WOOL, EquipmentClientInfo.builder().addHumanoidLayers(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"wool"), true).addHumanoidLayers(ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)"wool_overlay"), false).build());
    }

    public CompletableFuture<?> run(CachedOutput output) {
        HashMap map = new HashMap();
        TANEquipmentAssetProvider.bootstrap((key, info) -> {
            if (map.putIfAbsent(key, info) != null) {
                throw new IllegalStateException("Tried to register equipment asset twice for id: " + String.valueOf(key));
            }
        });
        return DataProvider.saveAll((CachedOutput)output, (Codec)EquipmentClientInfo.CODEC, arg_0 -> ((PackOutput.PathProvider)this.pathProvider).json(arg_0), map);
    }

    public String getName() {
        return "Equipment Asset Definitions";
    }
}

