/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.neoforge.datagen.model;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.TrimMaterialProperty;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import toughasnails.api.item.TANItems;
import toughasnails.client.item.TemperatureProperty;
import toughasnails.init.ModEquipmentAssets;

public class TANItemModelGenerators
extends ItemModelGenerators {
    public static final ResourceLocation TRIM_PREFIX_HELMET = TANItemModelGenerators.prefixForSlotTrim("helmet");
    public static final ResourceLocation TRIM_PREFIX_CHESTPLATE = TANItemModelGenerators.prefixForSlotTrim("chestplate");
    public static final ResourceLocation TRIM_PREFIX_LEGGINGS = TANItemModelGenerators.prefixForSlotTrim("leggings");
    public static final ResourceLocation TRIM_PREFIX_BOOTS = TANItemModelGenerators.prefixForSlotTrim("boots");
    public final ItemModelOutput itemModelOutput;
    public final BiConsumer<ResourceLocation, ModelInstance> modelOutput;
    private static final int NUM_THERMOMETER_MODELS = 21;

    public TANItemModelGenerators(ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        super(itemModelOutput, modelOutput);
        this.itemModelOutput = itemModelOutput;
        this.modelOutput = modelOutput;
    }

    public void run() {
        this.generateFlatItem(TANItems.ICE_CREAM, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.CHARC_0S, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.EMPTY_LEATHER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.LEATHER_DIRTY_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.LEATHER_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.LEATHER_PURIFIED_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.EMPTY_COPPER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.COPPER_DIRTY_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.COPPER_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.COPPER_PURIFIED_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.EMPTY_IRON_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.IRON_DIRTY_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.IRON_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.IRON_PURIFIED_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.EMPTY_GOLD_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.GOLD_DIRTY_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.GOLD_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.GOLD_PURIFIED_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.EMPTY_DIAMOND_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.DIAMOND_DIRTY_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.DIAMOND_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.DIAMOND_PURIFIED_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.EMPTY_NETHERITE_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.NETHERITE_DIRTY_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.NETHERITE_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.NETHERITE_PURIFIED_WATER_CANTEEN, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.DIRTY_WATER_BOTTLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.PURIFIED_WATER_BOTTLE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.APPLE_JUICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.CACTUS_JUICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.CHORUS_FRUIT_JUICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.GLOW_BERRY_JUICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.MELON_JUICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.PUMPKIN_JUICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.SWEET_BERRY_JUICE, ModelTemplates.FLAT_ITEM);
        this.generateFlatItem(TANItems.TAN_ICON, ModelTemplates.FLAT_ITEM);
        this.generateTrimmableItemWithDefaultColor(TANItems.LEAF_HELMET, ModEquipmentAssets.LEAF, TRIM_PREFIX_HELMET, -12012264);
        this.generateTrimmableItemWithDefaultColor(TANItems.LEAF_CHESTPLATE, ModEquipmentAssets.LEAF, TRIM_PREFIX_CHESTPLATE, -12012264);
        this.generateTrimmableItemWithDefaultColor(TANItems.LEAF_LEGGINGS, ModEquipmentAssets.LEAF, TRIM_PREFIX_LEGGINGS, -12012264);
        this.generateTrimmableItemWithDefaultColor(TANItems.LEAF_BOOTS, ModEquipmentAssets.LEAF, TRIM_PREFIX_BOOTS, -12012264);
        this.generateTrimmableItem(TANItems.WOOL_HELMET, ModEquipmentAssets.WOOL, TRIM_PREFIX_HELMET, true);
        this.generateTrimmableItem(TANItems.WOOL_CHESTPLATE, ModEquipmentAssets.WOOL, TRIM_PREFIX_CHESTPLATE, true);
        this.generateTrimmableItem(TANItems.WOOL_LEGGINGS, ModEquipmentAssets.WOOL, TRIM_PREFIX_LEGGINGS, true);
        this.generateTrimmableItem(TANItems.WOOL_BOOTS, ModEquipmentAssets.WOOL, TRIM_PREFIX_BOOTS, true);
        this.generateThermometerItem(TANItems.THERMOMETER);
    }

    public void generateTrimmableItemWithDefaultColor(Item item, ResourceKey<EquipmentAsset> key, ResourceLocation prefix, int defaultColor) {
        ResourceLocation modelLocation = ModelLocationUtils.getModelLocation((Item)item);
        ResourceLocation textureLocation = TextureMapping.getItemTexture((Item)item);
        ResourceLocation overlayTextureLocation = TextureMapping.getItemTexture((Item)item, (String)"_overlay");
        ArrayList<SelectItemModel.SwitchCase> list = new ArrayList<SelectItemModel.SwitchCase>(TRIM_MATERIAL_MODELS.size());
        for (ItemModelGenerators.TrimMaterialData itemmodelgenerators$trimmaterialdata : TRIM_MATERIAL_MODELS) {
            ResourceLocation resourcelocation3 = modelLocation.withSuffix("_" + itemmodelgenerators$trimmaterialdata.assets().base().suffix() + "_trim");
            ResourceLocation resourcelocation4 = prefix.withSuffix("_" + itemmodelgenerators$trimmaterialdata.assets().assetId(key).suffix());
            this.generateLayeredItem(resourcelocation3, textureLocation, overlayTextureLocation, resourcelocation4);
            ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.tintedModel((ResourceLocation)resourcelocation3, (ItemTintSource[])new ItemTintSource[]{new Dye(defaultColor)});
            list.add(ItemModelUtils.when((Object)itemmodelgenerators$trimmaterialdata.materialKey(), (ItemModel.Unbaked)itemmodel$unbaked));
        }
        ModelTemplates.TWO_LAYERED_ITEM.create(modelLocation, TextureMapping.layered((ResourceLocation)textureLocation, (ResourceLocation)overlayTextureLocation), this.modelOutput);
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.tintedModel((ResourceLocation)modelLocation, (ItemTintSource[])new ItemTintSource[]{new Dye(defaultColor)});
        this.itemModelOutput.accept(item, ItemModelUtils.select((SelectItemModelProperty)new TrimMaterialProperty(), (ItemModel.Unbaked)itemmodel$unbaked1, list));
    }

    public void generateThermometerItem(Item item) {
        ArrayList<RangeSelectItemModel.Entry> entries = new ArrayList<RangeSelectItemModel.Entry>();
        for (int i = 0; i < 21; ++i) {
            entries.add(ItemModelUtils.override((ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(item, String.format("_%02d", i), ModelTemplates.FLAT_ITEM)), (float)((float)i / 20.0f)));
        }
        this.itemModelOutput.accept(item, ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new TemperatureProperty(), (float)1.0f, entries));
    }

    public static ResourceLocation prefixForSlotTrim(String p_399619_) {
        return ResourceLocation.fromNamespaceAndPath((String)"toughasnails", (String)("trims/items/" + p_399619_ + "_trim"));
    }
}

